/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.nifi.processors.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.spi.json.JacksonJsonNodeJsonProvider;
import com.jayway.jsonpath.spi.json.JsonProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.qubership.nifi.processors.json.context.JsonMergeContext;
import org.qubership.nifi.processors.json.exception.KeyNodeNotExistsException;
import org.qubership.nifi.processors.json.exception.NodeToInsertNotFoundException;

public class JsonPathHelper {
    public static final Configuration JACKSON_ALL_AS_LIST_CONFIGURATION = Configuration.builder().options(new Option[]{Option.ALWAYS_RETURN_LIST}).jsonProvider((JsonProvider)new JacksonJsonNodeJsonProvider()).build();
    public static final Configuration DEFAULT_JACKSON_CONFIGURATION = Configuration.defaultConfiguration().jsonProvider((JsonProvider)new JacksonJsonNodeJsonProvider());
    public static final Configuration CONFIGURATION_SUPPRESS_EXCEPTIONS = Configuration.builder().options(new Option[]{Option.SUPPRESS_EXCEPTIONS}).jsonProvider((JsonProvider)new JacksonJsonNodeJsonProvider()).build();
    public static final Configuration CONFIGURATION_GET_PATH_LIST_OF_ATTRIBUTE = Configuration.builder().jsonProvider((JsonProvider)new JacksonJsonNodeJsonProvider()).options(new Option[]{Option.AS_PATH_LIST}).build();
    private static final String JSON_PATH_DELIMITER = ".";
    private final DocumentContext json;

    public DocumentContext getJson() {
        return this.json;
    }

    public JsonPathHelper(JsonNode input) {
        this.json = JsonPath.parse((Object)input, (Configuration)JACKSON_ALL_AS_LIST_CONFIGURATION);
    }

    public JsonPathHelper(JsonNode input, Configuration configuration) {
        this.json = JsonPath.parse((Object)input, (Configuration)configuration);
    }

    public List<String> extractValuesByKey(String path, String key) {
        ArrayNode resultNodes = (ArrayNode)this.json.read(path + JSON_PATH_DELIMITER + key, new Predicate[0]);
        ArrayList<String> result = new ArrayList<String>(resultNodes.size());
        for (JsonNode node : resultNodes) {
            result.add(node.asText());
        }
        return result;
    }

    public List<String> extractValuesByKey(String path) {
        ArrayNode resultNodes = (ArrayNode)this.json.read(path, new Predicate[0]);
        ArrayList<String> result = new ArrayList<String>(resultNodes.size());
        for (JsonNode node : resultNodes) {
            result.add(node.asText());
        }
        return result;
    }

    public void merge(JsonMergeContext context) throws NodeToInsertNotFoundException, KeyNodeNotExistsException {
        if (this.isValuesPresent(context.getNodes())) {
            return;
        }
        if (StringUtils.isBlank((CharSequence)context.getPathToInsert())) {
            Multimap<String, JsonNode> source = this.convertObjectNodesToMap(context.getKeyFromSourceToTarget(), this.readNodesByPath(context.getPath()));
            this.mergeValues(context, source);
        } else {
            this.mergeValues(context);
        }
    }

    private boolean isValuesPresent(ArrayNode array) {
        return array == null || array.size() == 0;
    }

    public Multimap<String, JsonNode> convertObjectNodesToMap(String key, ArrayNode nodes) throws KeyNodeNotExistsException {
        ArrayListMultimap result = ArrayListMultimap.create();
        for (JsonNode node : nodes) {
            result.put((Object)this.extractNodeByKey(key, node).asText(), (Object)node);
        }
        return result;
    }

    private JsonNode extractNodeByKey(String key, JsonNode node) throws KeyNodeNotExistsException {
        JsonNode result = node.get(key);
        if (result == null) {
            throw new KeyNodeNotExistsException("A key was not found: " + key);
        }
        return result;
    }

    public ArrayNode readNodesByPath(String path) throws NodeToInsertNotFoundException {
        ArrayNode result = (ArrayNode)this.json.read(path, new Predicate[0]);
        if (result.size() == 0) {
            throw new NodeToInsertNotFoundException("The path to objects is wrong: + " + path);
        }
        return result;
    }

    private void mergeValues(JsonMergeContext context, Multimap<String, JsonNode> source) throws KeyNodeNotExistsException {
        for (JsonNode value : context.getNodes()) {
            this.validateValue(value);
            JsonNode sourceIdNode = this.extractNodeByKey(context.getKeyFromTargetToSource(), value);
            Collection<JsonNode> sourceNodes = this.extractNodeByKey(sourceIdNode.asText(), source);
            this.mergeSingleValueToSource(context, value, sourceNodes);
            if (!context.isNeedToCleanTarget() || !value.isObject()) continue;
            ((ObjectNode)value).remove(context.getKeyFromTargetToSource());
        }
    }

    private void validateValue(JsonNode value) {
        if (!value.isObject()) {
            throw new IllegalArgumentException("A value must be a json object.");
        }
    }

    private Collection<JsonNode> extractNodeByKey(String key, Multimap<String, JsonNode> source) throws KeyNodeNotExistsException {
        Collection result = source.get((Object)key);
        if (result == null || result.isEmpty()) {
            throw new KeyNodeNotExistsException("A parent node by key was not found: " + key);
        }
        ArrayList<JsonNode> newResult = new ArrayList<JsonNode>();
        for (JsonNode res : result) {
            if (newResult.isEmpty()) {
                newResult.add(res);
                continue;
            }
            boolean addItem = true;
            for (JsonNode newRes : newResult) {
                if (newRes != res) continue;
                addItem = false;
                break;
            }
            if (!addItem) continue;
            newResult.add(res);
        }
        return newResult;
    }

    private void mergeSingleValueToSource(JsonMergeContext context, JsonNode value, Collection<JsonNode> sourceNodes) {
        for (JsonNode node : sourceNodes) {
            if (!node.isObject()) continue;
            if (context.isArray()) {
                ((ObjectNode)node).withArray(context.getKeyToInsertTarget()).add(value);
                continue;
            }
            ((ObjectNode)node).set(context.getKeyToInsertTarget(), value);
        }
    }

    private void mergeValues(JsonMergeContext context) throws NodeToInsertNotFoundException {
        ArrayNode nodesInWhichInsert = this.readNodesByPath(context.getPathToInsert());
        context.getNodes().forEach(value -> nodesInWhichInsert.forEach(node -> {
            if (node.isObject()) {
                if (context.isArray()) {
                    ((ObjectNode)node).withArray(context.getKeyToInsertTarget()).add(value);
                } else {
                    ((ObjectNode)node).set(context.getKeyToInsertTarget(), value);
                }
            } else if (node.isArray()) {
                ((ArrayNode)node).add(value);
            }
        }));
    }

    public void cleanUp(String path, String key) {
        this.json.delete(path + JSON_PATH_DELIMITER + key, new Predicate[0]);
    }

    public JsonNode getJsonNode() {
        return (JsonNode)this.json.json();
    }
}

