/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.nifi.processors.query;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.util.Tuple;
import org.qubership.nifi.NiFiUtils;
import org.qubership.nifi.service.dbjson.DBToJsonMappingTable;
import org.qubership.nifi.service.dbjson.type.DBType;
import org.qubership.nifi.service.dbjson.type.JsonType;

public abstract class AbstractRsToJsonWriter<T> {
    public static final int DEFAULT_BATCH_SIZE = 100;
    public static final int DEFAULT_FETCH_SIZE = 1000;
    private int batchSize = 100;
    private int fetchSize = 1000;
    DBToJsonMappingTable dbJsonMapping;

    public AbstractRsToJsonWriter(DBToJsonMappingTable dbJsonMapping) {
        this.dbJsonMapping = dbJsonMapping;
    }

    public long write(ResultSet rs, T out, ComponentLog logger) throws SQLException, IOException {
        return this.write(rs, "", out, logger);
    }

    public long write(ResultSet rs, String tableName, T out, ComponentLog logger) throws SQLException, IOException {
        ArrayNode nodes = JsonNodeFactory.instance.arrayNode();
        List<Tuple<String, Integer>> columns = this.extractColumns(rs.getMetaData());
        List<JsonType> jsonTypes = this.getJsonTypes(rs.getMetaData(), columns, tableName);
        int batchCounter = 0;
        long rowCounter = 0L;
        while (rs.next()) {
            ++rowCounter;
            nodes.add((JsonNode)this.convertToJson(rs, columns, jsonTypes, logger));
            if (this.batchSize > ++batchCounter) continue;
            this.writeJson((JsonNode)nodes, out);
            batchCounter = 0;
            nodes = JsonNodeFactory.instance.arrayNode();
        }
        if (nodes.size() > 0) {
            this.writeJson((JsonNode)nodes, out);
        }
        return rowCounter;
    }

    private List<Tuple<String, Integer>> extractColumns(ResultSetMetaData metaData) throws SQLException {
        ArrayList<Tuple> result = new ArrayList<Tuple>();
        for (int i = 1; i <= metaData.getColumnCount(); ++i) {
            result.add(new Tuple((Object)metaData.getColumnName(i), (Object)metaData.getColumnType(i)));
        }
        return Collections.unmodifiableList(result);
    }

    private List<JsonType> getJsonTypes(ResultSetMetaData metaData, List<Tuple<String, Integer>> columns, String tableName) throws SQLException {
        ArrayList<JsonType> jsonTypes = new ArrayList<JsonType>(columns.size());
        if (this.dbJsonMapping != null) {
            for (int i = 0; i < columns.size(); ++i) {
                String hypothesisTableName = metaData.getTableName(i + 1);
                if (hypothesisTableName.isEmpty()) {
                    hypothesisTableName = tableName;
                }
                JsonType fullJsonPath = this.dbJsonMapping.transform(new DBType(hypothesisTableName, (String)columns.get(i).getKey()));
                jsonTypes.add(i, fullJsonPath);
            }
        }
        return jsonTypes;
    }

    private ObjectNode convertToJson(ResultSet rs, List<Tuple<String, Integer>> columns, List<JsonType> jsonTypes, ComponentLog logger) throws SQLException, IOException {
        ObjectNode objNode = JsonNodeFactory.instance.objectNode();
        if (this.dbJsonMapping != null) {
            for (int i = 0; i < columns.size(); ++i) {
                Tuple<String, Integer> curColumn = columns.get(i);
                JsonType fullJsonPath = jsonTypes.get(i);
                if (fullJsonPath.isIgnore()) continue;
                String attributeName = fullJsonPath.getAttrName();
                if (this.isOrdinaryTimestamp((Integer)curColumn.getValue()) || this.isOrdinaryDate((Integer)curColumn.getValue()) || this.isOracleTimestamp((Integer)curColumn.getValue())) {
                    Timestamp tm = rs.getTimestamp(i + 1);
                    if (tm != null && ((Integer)curColumn.getValue() == 92 || (Integer)curColumn.getValue() == 93)) {
                        tm = rs.getTimestamp(i + 1, this.dbJsonMapping.getCalendar());
                    }
                    if (tm != null) {
                        objNode.put(attributeName, this.dbJsonMapping.formatTimestamp(tm));
                        continue;
                    }
                    objNode.put(attributeName, (String)null);
                    continue;
                }
                String rawValue = rs.getString(i + 1);
                if (rawValue == null && fullJsonPath.getSpecialType() == null) {
                    objNode.put(attributeName, rawValue);
                    continue;
                }
                if (fullJsonPath.getSpecialType() != null) {
                    try {
                        switch (fullJsonPath.getSpecialType()) {
                            case "boolean": {
                                objNode.put(attributeName, rs.getBoolean(i + 1));
                                break;
                            }
                            case "Boolean": {
                                Boolean boolVal = rs.getBoolean(i + 1);
                                if (rs.wasNull()) {
                                    boolVal = null;
                                }
                                objNode.put(attributeName, boolVal);
                                break;
                            }
                            case "object": {
                                if (rawValue == null) {
                                    objNode.put(attributeName, rawValue);
                                    break;
                                }
                                objNode.set(attributeName, NiFiUtils.MAPPER.readTree(rawValue));
                                break;
                            }
                            case "integer": {
                                objNode.put(attributeName, Integer.valueOf(rawValue));
                                break;
                            }
                            case "number": {
                                objNode.put(attributeName, Double.valueOf(rawValue));
                                break;
                            }
                            default: {
                                objNode.put(attributeName, rawValue);
                                break;
                            }
                        }
                    }
                    catch (Exception e) {
                        logger.warn("Can't parse '" + rawValue + "' as " + fullJsonPath.getSpecialType() + ", the value will be written as string");
                        objNode.put(attributeName, rawValue);
                    }
                    continue;
                }
                objNode.put(attributeName, rawValue);
            }
        } else {
            for (int i = 0; i < columns.size(); ++i) {
                objNode.put((String)columns.get(i).getKey(), rs.getString(i + 1));
            }
        }
        return objNode;
    }

    private boolean isOracleTimestamp(int type) {
        return type == -101 || type == -102;
    }

    private boolean isOrdinaryTimestamp(int type) {
        return type == 92 || type == 93 || type == 2013 || type == 2014;
    }

    private boolean isOrdinaryDate(int type) {
        return type == 91;
    }

    protected abstract void writeJson(JsonNode var1, T var2);

    public void setBatchSize(int batchSize) {
        if (batchSize > 0) {
            this.batchSize = batchSize;
        }
    }

    @Deprecated
    public void setFetchSize(int fetchSize) {
        if (fetchSize > 0) {
            this.fetchSize = fetchSize;
        }
    }

    public AbstractRsToJsonWriter() {
    }
}

