/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.nifi.processors.validator;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.components.Validator;

public abstract class AbstractJsonValidator<T>
implements Validator {
    private final ObjectMapper mapper;
    private final boolean allowEmpty;

    public ValidationResult validate(String subject, String input, ValidationContext context) {
        ValidationResult.Builder builder = new ValidationResult.Builder().subject(subject);
        String json = input;
        if (context.isExpressionLanguagePresent(input)) {
            try {
                json = context.newPropertyValue(input).evaluateAttributeExpressions().getValue();
            }
            catch (Exception e) {
                return builder.valid(false).explanation("Failed to evaluate Expression Language due to " + e.toString()).build();
            }
        }
        if (this.allowEmpty && (json == null || "".equals(json))) {
            return builder.valid(true).explanation("JSON is valid.").build();
        }
        try {
            List<String> validationMessages = this.validate(this.convert(json));
            if (!validationMessages.isEmpty()) {
                return builder.valid(false).explanation(String.valueOf(validationMessages)).build();
            }
        }
        catch (IOException e) {
            String explanation = e.getMessage();
            if (explanation != null && explanation.contains("at ")) {
                explanation = explanation.split("at ")[0];
            }
            return builder.valid(false).explanation(explanation).build();
        }
        catch (Exception e) {
            return builder.valid(false).explanation(e.getMessage()).build();
        }
        return builder.valid(true).explanation("JSON is valid.").build();
    }

    protected abstract T convert(String var1) throws IOException;

    protected List<String> validate(T obj) {
        return Collections.emptyList();
    }

    public AbstractJsonValidator(ObjectMapper mapper, boolean allowEmpty) {
        this.mapper = mapper;
        this.allowEmpty = allowEmpty;
    }

    public ObjectMapper getMapper() {
        return this.mapper;
    }

    public boolean isAllowEmpty() {
        return this.allowEmpty;
    }
}

