/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.cloud.nifi.registry.config;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.consul.config.ConsulPropertySource;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.cloud.context.environment.EnvironmentChangeEvent;
import org.springframework.context.event.EventListener;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Component;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

@Component
@RefreshScope
public class PropertiesManager {
    private static final Logger LOG = LoggerFactory.getLogger(PropertiesManager.class);
    @Value(value="classpath:logback-template.xml")
    private Resource sourceXmlFile;
    @Value(value="classpath:nifi_registry_default.properties")
    private Resource defaultPropertiesFile;
    @Value(value="classpath:nifi_registry_internal.properties")
    private Resource internalPropertiesFile;
    @Value(value="classpath:nifi_registry_internal_comments.properties")
    private Resource internalPropertiesCommentsFile;
    private Map<String, String> consulPropertiesMap = new HashMap<String, String>();
    private Properties props;
    @Value(value="${config.file.path}")
    private String path;
    @Autowired
    private ConfigurableEnvironment env;
    @Autowired
    private Environment appEnv;
    private static final Set<String> READ_ONLY_NIFI_REGISTRY_PROPS = new HashSet<String>();
    private static final int LOGGER_PREFIX_LENGTH;

    public void generateNifiRegistryProperties() throws IOException, ParserConfigurationException, TransformerException, SAXException {
        this.readConsulProperties();
        this.buildPropertiesFile();
        this.buildLogbackXMLFile();
        LOG.info("nifi registry properties files generated");
    }

    private void buildLogbackXMLFile() throws ParserConfigurationException, IOException, SAXException, TransformerException {
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        dbFactory.setFeature("http://xml.org/sax/features/external-general-entities", false);
        dbFactory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        dbFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        dbFactory.setXIncludeAware(false);
        dbFactory.setExpandEntityReferences(false);
        DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
        Document doc = null;
        try (BufferedInputStream is = new BufferedInputStream(this.sourceXmlFile.getInputStream());){
            doc = dBuilder.parse(is);
        }
        doc.getDocumentElement().normalize();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Root element: {}", (Object)doc.getDocumentElement().getNodeName());
        }
        NodeList nodeList = doc.getElementsByTagName("logger");
        for (String consulKey : this.consulPropertiesMap.keySet()) {
            boolean loggerElementFound = false;
            if (!consulKey.toLowerCase().startsWith("logger.")) continue;
            String xmlKey = consulKey.substring(LOGGER_PREFIX_LENGTH);
            if (LOG.isDebugEnabled()) {
                LOG.debug("current xmlKey: {}", (Object)xmlKey);
            }
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node loggerKey;
                Node prop = nodeList.item(i);
                NamedNodeMap attr = prop.getAttributes();
                if (attr == null || !xmlKey.equalsIgnoreCase((loggerKey = attr.getNamedItem("name")).getNodeValue())) continue;
                attr.getNamedItem("level").setTextContent(this.consulPropertiesMap.get(consulKey));
                loggerElementFound = true;
                break;
            }
            if (loggerElementFound) continue;
            Element newLogger = doc.createElement("logger");
            newLogger.setAttribute("name", xmlKey);
            newLogger.setAttribute("level", this.consulPropertiesMap.get(consulKey));
            Node firstLogNode = doc.getElementsByTagName("logger").item(0);
            doc.getDocumentElement().insertBefore(newLogger, firstLogNode);
        }
        try (BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(this.path + "logback.xml"));){
            this.writeXml(doc, output);
        }
        LOG.info("logback.xml file created at path: {}", (Object)this.path);
    }

    private void writeXml(Document doc, OutputStream output) throws TransformerException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        DOMSource source = new DOMSource(doc);
        StreamResult result = new StreamResult(output);
        transformer.transform(source, result);
    }

    private void readConsulProperties() {
        MutablePropertySources srcs = this.env.getPropertySources();
        HashSet<String> allPropertyNames = new HashSet<String>();
        for (PropertySource src1 : srcs) {
            String[] allNames;
            if (!ConsulPropertySource.class.isAssignableFrom(src1.getClass()) || (allNames = ((ConsulPropertySource)src1).getPropertyNames()) == null) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug("allNames array: {}", List.of(allNames));
            }
            for (String name : allNames) {
                String lowercaseName = name.toLowerCase();
                if (!lowercaseName.startsWith("logger") && !lowercaseName.startsWith("nifi.registry")) continue;
                allPropertyNames.add(name);
            }
        }
        LOG.debug("All property names = {}", allPropertyNames);
        for (String property : allPropertyNames) {
            this.consulPropertiesMap.put(property, this.appEnv.getProperty(property));
        }
        LOG.debug("consulPropertiesMap map: {}", this.consulPropertiesMap);
    }

    public void buildPropertiesFile() throws IOException {
        String fileName = this.path + "nifi-registry.properties";
        Map<String, String> combinedNifiRegistryProperties = this.getOrderedProperties(this.defaultPropertiesFile);
        Map<String, String> nifiRegistryInternalProps = this.getOrderedProperties(this.internalPropertiesFile);
        for (String s : nifiRegistryInternalProps.keySet()) {
            combinedNifiRegistryProperties.put(s, nifiRegistryInternalProps.get(s));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("combined nifi registry Properties: {}", combinedNifiRegistryProperties);
        }
        for (String s : READ_ONLY_NIFI_REGISTRY_PROPS) {
            combinedNifiRegistryProperties.remove(s);
        }
        try (PrintWriter pw = new PrintWriter(new FileOutputStream(fileName));
             BufferedReader reader = new BufferedReader(new InputStreamReader(this.internalPropertiesCommentsFile.getInputStream()));){
            for (String s : combinedNifiRegistryProperties.keySet()) {
                pw.print(s);
                pw.print("=");
                pw.println(combinedNifiRegistryProperties.get(s));
            }
            String line = reader.readLine();
            while (line != null) {
                pw.println(line);
                line = reader.readLine();
            }
        }
        LOG.info("Nifi Registry Properties file created : {}", (Object)fileName);
    }

    public Map<String, String> getOrderedProperties(Resource rs) throws IOException {
        final LinkedHashMap<String, String> mp = new LinkedHashMap<String, String>();
        try (InputStream in = rs.getInputStream();){
            new Properties(){

                @Override
                public synchronized Object put(Object key, Object value) {
                    return mp.put((String)key, (String)value);
                }
            }.load(in);
        }
        return mp;
    }

    @EventListener
    public void handleChangeEvent(EnvironmentChangeEvent event) {
        LOG.debug("Change event received for keys: {}", (Object)event.getKeys());
        this.readConsulProperties();
        try {
            this.buildLogbackXMLFile();
        }
        catch (Exception e) {
            LOG.error("Exception while processing change event from consul", (Throwable)e);
        }
    }

    static {
        READ_ONLY_NIFI_REGISTRY_PROPS.add("nifi.registry.security.identity.mapping.pattern.dn");
        READ_ONLY_NIFI_REGISTRY_PROPS.add("nifi.registry.security.identity.mapping.value.dn");
        READ_ONLY_NIFI_REGISTRY_PROPS.add("nifi.registry.security.identity.mapping.transform.dn");
        LOGGER_PREFIX_LENGTH = "logger.".length();
    }
}

