/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.nifi.service;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.controller.AbstractControllerService;
import org.apache.nifi.processor.ProcessContext;
import org.qubership.nifi.service.DBElementType;
import org.qubership.nifi.service.PreparedStatementProvider;

public abstract class AbstractPreparedStatementProvider
extends AbstractControllerService
implements PreparedStatementProvider {
    protected String charArrayType;
    protected String numArrayType;

    protected Object[] convertArray(Collection<String> ids, DBElementType type) {
        ArrayList<Object> res = new ArrayList<Object>();
        for (String id : ids) {
            if (!StringUtils.isNotEmpty((CharSequence)id) || "null".equalsIgnoreCase(id)) continue;
            if (type == DBElementType.NUMERIC) {
                res.add(new BigDecimal(id));
                continue;
            }
            res.add(id);
        }
        return res.toArray();
    }

    protected String getArrayType(DBElementType type) {
        if (type == DBElementType.NUMERIC) {
            return this.numArrayType;
        }
        if (type == DBElementType.CHAR) {
            return this.charArrayType;
        }
        return this.charArrayType;
    }

    public PreparedStatement createPreparedStatement(String query, ProcessContext context, Collection<String> ids, Connection con, int numberOfBinds, int bindsOffset) throws SQLException {
        return this.createPreparedStatement(query, context, ids, con, DBElementType.CHAR, numberOfBinds, bindsOffset);
    }

    public PreparedStatement createPreparedStatement(String query, ProcessContext context, Collection<String> ids, Connection con) throws SQLException {
        return this.createPreparedStatement(query, context, ids, con, 1, 0);
    }

    public PreparedStatement createPreparedStatement(String query, ProcessContext context, Collection<String> ids, Connection con, DBElementType type) throws SQLException {
        return this.createPreparedStatement(query, context, ids, con, type, 1, 0);
    }
}

