/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.nifi.service;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnEnabled;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.util.StandardValidators;
import org.qubership.nifi.service.AbstractPreparedStatementProvider;
import org.qubership.nifi.service.DBElementType;
import org.qubership.nifi.service.PreparedStatementProvider;

@Tags(value={"properties"})
@CapabilityDescription(value="Provides a prepared statement service.")
public class PostgresPreparedStatementWithArrayProvider
extends AbstractPreparedStatementProvider
implements PreparedStatementProvider {
    public static final PropertyDescriptor CHAR_ARRAY_TYPE = new PropertyDescriptor.Builder().name("array-type").displayName("Char Array Type").description("Character array base type.").defaultValue("text").addValidator(StandardValidators.NON_EMPTY_VALIDATOR).required(false).build();
    public static final PropertyDescriptor NUMERIC_ARRAY_TYPE = new PropertyDescriptor.Builder().name("numeric-array-type").displayName("Numeric Array Type").description("Numeric array base type.").defaultValue("numeric").addValidator(StandardValidators.NON_EMPTY_VALIDATOR).required(false).build();
    private List<PropertyDescriptor> propDescriptors;

    public PostgresPreparedStatementWithArrayProvider() {
        ArrayList<PropertyDescriptor> pds = new ArrayList<PropertyDescriptor>();
        pds.add(CHAR_ARRAY_TYPE);
        pds.add(NUMERIC_ARRAY_TYPE);
        this.propDescriptors = Collections.unmodifiableList(pds);
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return this.propDescriptors;
    }

    @OnEnabled
    public void onEnable(ConfigurationContext context) {
        this.charArrayType = context.getProperty(CHAR_ARRAY_TYPE).getValue();
        this.numArrayType = context.getProperty(NUMERIC_ARRAY_TYPE).getValue();
    }

    public PreparedStatement createPreparedStatement(String query, ProcessContext context, Collection<String> ids, Connection con, DBElementType type, int numberOfBinds, int bindsOffset) throws SQLException {
        PreparedStatement result = con.prepareStatement(query);
        String arrayType = this.getArrayType(type);
        Object[] idArray = this.convertArray(ids, type);
        for (int cnt = bindsOffset + 1; cnt < bindsOffset + numberOfBinds + 1; ++cnt) {
            result.setArray(cnt, con.createArrayOf(arrayType, idArray));
        }
        return result;
    }
}

