/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.nifi.service.validation;

import com.fasterxml.jackson.databind.JsonNode;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonSchemaFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.lifecycle.OnEnabled;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.controller.AbstractControllerService;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.reporting.InitializationException;
import org.qubership.nifi.JsonUtils;
import org.qubership.nifi.service.validation.ContentValidator;

@CapabilityDescription(value="Provides validate method to check the JSON against a given schema.")
public class JsonContentValidator
extends AbstractControllerService
implements ContentValidator {
    public static final PropertyDescriptor SCHEMA = new PropertyDescriptor.Builder().name("schema").displayName("Schema").description("Validation Json Schema.").required(true).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).build();
    private JsonSchema schemaInstance;

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        ArrayList<PropertyDescriptor> properties = new ArrayList<PropertyDescriptor>();
        properties.add(SCHEMA);
        return properties;
    }

    @OnEnabled
    public void onConfigured(ConfigurationContext context) throws InitializationException {
        String sSchema = context.getProperty(SCHEMA).getValue();
        this.schemaInstance = JsonSchemaFactory.getInstance().getSchema(sSchema);
    }

    public boolean validate(String value, Map<String, String> attributes) throws IOException {
        JsonNode jsonValue = JsonUtils.MAPPER.readTree(value);
        Set errors = this.schemaInstance.validate(jsonValue);
        return errors.isEmpty();
    }

    @Generated
    public JsonContentValidator() {
    }
}

