/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.agent.http;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URLDecoder;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Set;
import org.qubership.profiler.agent.CallInfo;
import org.qubership.profiler.agent.Profiler;
import org.qubership.profiler.agent.ProfilerData;
import org.qubership.profiler.agent.ProfilerProperty;
import org.qubership.profiler.agent.StringUtils;
import org.qubership.profiler.agent.http.CookieAdapter;
import org.qubership.profiler.agent.http.HttpServletRequestAdapter;
import org.qubership.profiler.agent.http.HttpSessionAdapter;
import org.qubership.profiler.agent.http.ServletRequestAdapter;

public class HttpServletLogUtils {
    private static final String LOG_HEADERS_PROPERTY = "events.http.headers";
    private static Set<String> headersToLog;

    public static void fillNcUser(ServletRequestAdapter request) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        CallInfo callInfo = Profiler.getState().callInfo;
        if (!request.isHttpServetRequest()) {
            return;
        }
        if (callInfo.getNcUser() != null && !"null".equals(callInfo.getNcUser())) {
            return;
        }
        HttpServletRequestAdapter req = request.toHttpServletRequestAdapter();
        HttpSessionAdapter session = req.getSession(false);
        if (session == null) {
            return;
        }
        if (callInfo.getNcUser() == null) {
            Object springSecurityContext;
            try {
                springSecurityContext = session.getAttribute("SPRING_SECURITY_CONTEXT");
            }
            catch (Exception e) {
                return;
            }
            if (springSecurityContext != null) {
                try {
                    Method getUsername;
                    Object user;
                    Method getPrincipal;
                    Object principal;
                    Method getAuthentication = springSecurityContext.getClass().getMethod("getAuthentication", new Class[0]);
                    Object authentication = getAuthentication.invoke(springSecurityContext, new Object[0]);
                    if (authentication != null && (principal = (getPrincipal = authentication.getClass().getMethod("getPrincipal", new Class[0])).invoke(authentication, new Object[0])) != null && (user = (getUsername = principal.getClass().getMethod("getUsername", new Class[0])).invoke(principal, new Object[0])) != null) {
                        callInfo.setNcUser(String.valueOf(user));
                    }
                }
                catch (NoSuchMethodException noSuchMethodException) {
                }
                catch (InvocationTargetException invocationTargetException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
        }
        if (callInfo.getNcUser() != null && !"null".equals(callInfo.getNcUser())) {
            HttpServletLogUtils.dumpNCUserInfo(request.getRemoteAddr(), callInfo);
        }
    }

    public static void dumpRequest(ServletRequestAdapter request) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        CallInfo callInfo = Profiler.getState().callInfo;
        if (request.isHttpServetRequest()) {
            String query;
            HttpServletRequestAdapter req = request.toHttpServletRequestAdapter();
            String url = req.getRequestURL().toString();
            Profiler.event((Object)url, "web.url");
            if (url != null) {
                callInfo.setRequestURL(url);
                url = StringUtils.right(url, 46);
                url = req.getMethod().substring(0, 1) + ' ' + url;
                callInfo.setModule(url);
            }
            if ((query = req.getQueryString()) != null && query.length() > 0) {
                Profiler.event((Object)query, "web.query");
                callInfo.setAction(query);
            }
            HttpServletLogUtils.dumpSessionInfo(req, callInfo);
            Profiler.event((Object)req.getRequestedSessionId(), "web.session.id");
            Profiler.event((Object)req.getMethod(), "web.method");
            Profiler.event((Object)req.getHeader("Referer"), "_web.referer");
            Profiler.event((Object)req.getHeader("dynaTrace"), "dynatrace");
            Profiler.event((Object)req.getHeader("X-JMeter-Step"), "jmeter.step");
            Profiler.event((Object)req.getHeader("x-request-id"), "x-request-id");
            String clientTransactionId = req.getHeader("x-client-transaction-id");
            Profiler.event((Object)clientTransactionId, "x-client-transaction-id");
            String traceId = req.getHeader("X-B3-TraceId");
            Profiler.event((Object)traceId, "X-B3-TraceId");
            Profiler.event((Object)req.getHeader("X-B3-SpanId"), "X-B3-SpanId");
            Profiler.event((Object)req.getHeader("X-B3-ParentSpanId"), "X-B3-ParentSpanId");
            for (String header : headersToLog) {
                Profiler.event((Object)req.getHeader(header), header);
            }
            String endToEndId = req.getHeader("X-EndToEndId");
            CookieAdapter[] cookies = req.getCookies();
            if ((endToEndId == null || endToEndId.length() == 0) && cookies != null) {
                for (CookieAdapter cookie : cookies) {
                    String[] pairs;
                    if ("nc.esc.tid".equals(cookie.getName())) {
                        endToEndId = cookie.getValue();
                        break;
                    }
                    if (!"PT".equals(cookie.getName())) continue;
                    String pt = cookie.getValue();
                    LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
                    for (String pair : pairs = pt.split("&")) {
                        int idx = pair.indexOf("=");
                        try {
                            params.put(URLDecoder.decode(pair.substring(0, idx), "UTF-8"), URLDecoder.decode(pair.substring(idx + 1), "UTF-8"));
                        }
                        catch (UnsupportedEncodingException unsupportedEncodingException) {
                            // empty catch block
                        }
                    }
                    String scenario = (String)params.get("sn.scenario");
                    String source = (String)params.get("pt.source");
                    if (source == null) break;
                    if (source.length() > 40) {
                        source = source.substring(0, 40);
                    }
                    if (scenario != null) {
                        source = scenario + "_" + source;
                    }
                    String start = (String)params.get("pt.start");
                    String uid = (String)params.get("sn.uid");
                    endToEndId = source + "#" + start;
                    if (uid == null) break;
                    endToEndId = endToEndId + "#" + uid;
                    break;
                }
            }
            if (endToEndId == null && traceId != null) {
                endToEndId = traceId;
            }
            if (endToEndId == null && clientTransactionId != null) {
                endToEndId = clientTransactionId;
            }
            if (endToEndId != null && endToEndId.length() > 0) {
                callInfo.setEndToEndId(endToEndId);
            }
        }
        String remoteAddr = request.getRemoteAddr();
        Profiler.event((Object)remoteAddr, "web.remote.addr");
        callInfo.setRemoteAddress(remoteAddr);
        HttpServletLogUtils.dumpNCUserInfo(remoteAddr, callInfo);
        Profiler.event((Object)request.getRemoteHost(), "web.remote.host");
    }

    public static void dumpNCUserInfo(String remoteAddr, CallInfo callInfo) {
        StringBuilder sb = new StringBuilder(25);
        String userName = callInfo.getNcUser();
        if (userName != null) {
            Profiler.event((Object)userName, "nc.user");
            sb.append(userName);
        }
        sb.append('@').append(remoteAddr);
        callInfo.setCliendId(sb.toString());
    }

    public static void afterRequest(ServletRequestAdapter request) throws InvocationTargetException, IllegalAccessException, NoSuchMethodException {
        CallInfo callInfo = Profiler.getState().callInfo;
        if (callInfo.getEndToEndId() != null && callInfo.getEndToEndId().length() != 0) {
            request.setAttribute("x-nc-trace-id", callInfo.getEndToEndId());
        }
        if (callInfo.getNcUser() == null && request.isHttpServetRequest()) {
            HttpServletLogUtils.dumpSessionInfo(request.toHttpServletRequestAdapter(), callInfo);
        }
    }

    public static void dumpSessionInfo(HttpServletRequestAdapter req, CallInfo callInfo) throws IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        Object userSession;
        HttpSessionAdapter session = req.getSession(false);
        if (session != null && (userSession = session.getAttribute("usession")) != null) {
            Class<?> sessionClass = userSession.getClass();
            try {
                Method getId;
                Object sessionId;
                Method getUserName = sessionClass.getMethod("getUserName", new Class[0]);
                String ncUser = (String)getUserName.invoke(userSession, new Object[0]);
                callInfo.setNcUser(ncUser);
                if (ncUser != null) {
                    req.setAttribute("x-nc-username", ncUser);
                }
                if ((sessionId = (getId = sessionClass.getMethod("getID", new Class[0])).invoke(userSession, new Object[0])) != null) {
                    req.setAttribute("x-nc-session-id", String.valueOf(sessionId));
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    static {
        ProfilerProperty profilerProperty = ProfilerData.properties.get(LOG_HEADERS_PROPERTY);
        headersToLog = profilerProperty != null ? profilerProperty.getMultipleValues() : Collections.EMPTY_SET;
    }
}

