/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.agent;

import java.util.Scanner;
import java.util.logging.Level;
import org.qubership.profiler.agent.ESCLogger;
import org.qubership.profiler.agent.PropertyFacadeBoot;
import org.qubership.profiler.agent.StringUtils;

public class ServerNameResolverAgent {
    private static final ESCLogger logger = ESCLogger.getLogger(ServerNameResolverAgent.class.getName());
    public static final String PARAM_POD_NAME = "POD_NAME";
    public static final String DEFAULT_SERVER_NAME = "default";
    public static final String POD_NAME = ServerNameResolverAgent.parsePODName();
    public static final String SERVER_NAME = System.getProperty("org.qubership.esc.serverName", System.getProperty("weblogic.Name", System.getProperty("jboss.server.name", POD_NAME)));

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String parsePODName() {
        String result = PropertyFacadeBoot.getPropertyOrEnvVariable(PARAM_POD_NAME);
        if (!StringUtils.isBlank(result)) {
            return result;
        }
        try (Scanner s = new Scanner(Runtime.getRuntime().exec("hostname").getInputStream()).useDelimiter("\\A");){
            if (!s.hasNext()) return DEFAULT_SERVER_NAME;
            String string = s.next().trim();
            return string;
        }
        catch (Throwable t) {
            logger.log(Level.WARNING, "Exception in getting hostname", t);
        }
        return DEFAULT_SERVER_NAME;
    }

    static {
        if (System.getProperty("org.qubership.esc.serverName") == null) {
            System.setProperty("org.qubership.esc.serverName", SERVER_NAME);
        }
    }
}

