/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.agent;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import org.qubership.profiler.agent.LocalState;
import org.qubership.profiler.agent.ProfilerData;
import org.qubership.profiler.agent.ThreadJMXWaitProvider;
import org.qubership.profiler.agent.TimerCache;

public class ThreadJMXWait
implements ThreadJMXWaitProvider {
    private static final ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();

    @Override
    public void updateThreadCounters(LocalState state) {
        int now = TimerCache.timer;
        if (now - state.nextWaitStamp < 0) {
            return;
        }
        ThreadInfo info = threadMXBean.getThreadInfo(state.thread.getId());
        state.waitTime = info.getWaitedTime();
        state.nextWaitStamp = now + ProfilerData.THREAD_WAIT_MINIMAL_CALL_DURATION;
    }
}

