/*
 * Decompiled with CFR 0.152.
 */
package com.netcracker.profiler.agent;

import com.netcracker.profiler.agent.Bootstrap;
import com.netcracker.profiler.agent.ProfilerData;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.Method;

public class FindJMXImplementation {
    public static String[] find() {
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        String cpuMonitoringClass = "com.netcracker.profiler.agent.ThreadJMXCpuEmpty";
        try {
            if (ProfilerData.THREAD_CPU && threadMXBean.isCurrentThreadCpuTimeSupported()) {
                cpuMonitoringClass = "com.netcracker.profiler.agent.ThreadJMXCpu";
            }
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        String waitMonitoringClass = "com.netcracker.profiler.agent.ThreadJMXWaitEmpty";
        try {
            if (ProfilerData.THREAD_WAIT && threadMXBean.isThreadContentionMonitoringSupported()) {
                if (!threadMXBean.isThreadContentionMonitoringEnabled()) {
                    threadMXBean.setThreadContentionMonitoringEnabled(true);
                }
                if (threadMXBean.isThreadContentionMonitoringEnabled()) {
                    waitMonitoringClass = "com.netcracker.profiler.agent.ThreadJMXWait";
                }
            }
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        String memoryMonitoringClass = "com.netcracker.profiler.agent.ThreadJMXMemoryEmpty";
        if (ProfilerData.THREAD_MEMORY) {
            try {
                Method getThreadAllocatedBytes = threadMXBean.getClass().getMethod("getThreadAllocatedBytes", Long.TYPE);
                getThreadAllocatedBytes.setAccessible(true);
                Long bytes = (Long)getThreadAllocatedBytes.invoke((Object)threadMXBean, Thread.currentThread().getId());
                if (bytes != null) {
                    memoryMonitoringClass = "com.netcracker.profiler.agent.ThreadJMXMemory";
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        Bootstrap.info("Profiler: using the following thread jmx monitors: " + cpuMonitoringClass + ", " + waitMonitoringClass + ", " + memoryMonitoringClass);
        return new String[]{cpuMonitoringClass, waitMonitoringClass, memoryMonitoringClass};
    }
}

