/*
 * Decompiled with CFR 0.152.
 */
package com.netcracker.profiler.agent;

import com.netcracker.profiler.agent.LocalState;
import com.netcracker.profiler.agent.Profiler;
import com.netcracker.profiler.agent.ProfilerData;
import com.netcracker.profiler.agent.StringUtils;
import com.netcracker.profiler.agent.TimerCache;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;

public class LocalBuffer {
    public static final int SIZE = Integer.getInteger(LocalBuffer.class.getName() + ".SIZE", 4096);
    private static final AtomicLongFieldUpdater<LocalBuffer> START_TIME_UPDATER = AtomicLongFieldUpdater.newUpdater(LocalBuffer.class, "startTime");
    public volatile LocalState state;
    public LocalBuffer prevBuffer;
    public final long[] data = new long[SIZE];
    public final Object[] value = new Object[SIZE];
    public volatile long startTime;
    public volatile int count;
    public volatile int first;
    public boolean corrupted;
    private long largeEventsVolume;

    public LocalBuffer() {
        this.init(null);
    }

    public void increaseStartTime(long value) {
        START_TIME_UPDATER.addAndGet(this, value);
    }

    public void init(LocalBuffer prevBuffer) {
        this.startTime = TimerCache.now;
        this.count = 0;
        this.first = 0;
        this.resetLargeEventsVolume();
        this.prevBuffer = prevBuffer;
    }

    public void event(Object contents, int tagId) {
        int r = this.count;
        long[] data = this.data;
        if (r >= 0 && r < data.length) {
            data[r] = (long)tagId | TimerCache.timerSHL32;
            if (contents instanceof CharSequence) {
                contents = this.truncateCharSequence(contents);
            }
            this.value[r] = contents;
            this.count = r + 1;
        } else {
            LocalState state = this.state;
            Profiler.exchangeBuffer(this);
            state.buffer.event(contents, tagId);
        }
    }

    private Object truncateCharSequence(Object contents) {
        CharSequence s = (CharSequence)contents;
        int length = s.length();
        if (length < ProfilerData.LARGE_EVENT_THRESHOLD) {
            return contents;
        }
        LocalState state = this.state;
        if (state.reserveLargeEventVolume(length)) {
            this.largeEventsVolume += (long)length;
            return contents;
        }
        contents = s.subSequence(0, ProfilerData.TRUNCATED_EVENTS_THRESHOLD) + "... truncated from " + length + " chars";
        return contents;
    }

    public void initEnter(int methodId) {
        this.initTimedEnter((long)methodId | TimerCache.timerSHL32);
    }

    public void initEnter(long methodAndTime) {
        this.initTimedEnter(methodAndTime);
    }

    public void initTimedEnter(long methodAndTime) {
        int r = this.count;
        long[] data = this.data;
        if (r >= 0 && r < data.length) {
            data[r] = methodAndTime;
            this.count = r + 1;
        } else {
            Profiler.exchangeBuffer(this, methodAndTime);
        }
    }

    public void initExit() {
        this.initTimedExit(TimerCache.timerSHL32);
    }

    public void initTimedExit(long time) {
        int r = this.count;
        long[] data = this.data;
        if (r >= 0 && r < data.length) {
            data[r] = time;
            this.count = r + 1;
        } else {
            Profiler.exchangeBuffer(this, time);
        }
    }

    public void reset() {
        if (this.first < this.count && this.first >= 0) {
            Arrays.fill(this.value, this.first, this.count, null);
        }
        this.first = 0;
        this.count = 0;
        this.prevBuffer = this;
        this.corrupted = false;
        this.resetLargeEventsVolume();
    }

    private void resetLargeEventsVolume() {
        long volume = this.largeEventsVolume;
        if (volume <= 0L) {
            return;
        }
        this.largeEventsVolume = 0L;
        ProfilerData.reserveLargeEventVolume(-volume);
    }

    public String toString() {
        return "LocalBuffer{" + System.identityHashCode(this) + " corrupted=" + this.corrupted + ", state=" + System.identityHashCode(this.state) + ", count=" + this.count + ", first=" + this.first + ", startTime=" + this.startTime + ", data=" + StringUtils.arrayToString(new StringBuilder(), Arrays.copyOf(this.data, 20)) + ", value=" + StringUtils.arrayToString(new StringBuilder(), Arrays.copyOf(this.value, 20)) + ", prevBuffer=" + System.identityHashCode(this.prevBuffer) + '}';
    }

    public void command(byte commandId, Object result) {
        this.count = -1;
        this.data[0] = commandId;
        this.value[0] = result;
    }
}

