/*
 * Decompiled with CFR 0.152.
 */
package com.netcracker.profiler.agent;

import com.netcracker.profiler.agent.Bootstrap;
import com.netcracker.profiler.agent.ESCLogger;
import com.netcracker.profiler.agent.ProfilerTransformerPlugin;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;

public class PluginClassLoader
extends URLClassLoader {
    public static final boolean DEBUG_PRELOADING = Boolean.getBoolean(PluginClassLoader.class.getName() + ".debug_preloading");
    private static final ESCLogger logger = ESCLogger.getLogger(PluginClassLoader.class, DEBUG_PRELOADING ? Level.FINE : ESCLogger.ESC_LOG_LEVEL);
    String[] entryPoints;
    private final String preloadList;

    public PluginClassLoader(ClassLoader parent, URL[] urls, String[] entryPoints, String preloadList) {
        super(urls, parent);
        this.entryPoints = entryPoints;
        this.preloadList = preloadList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void preload(String listName) {
        URL url = this.findResource(listName);
        if (url == null) {
            return;
        }
        BufferedReader br = null;
        try {
            String s;
            br = new BufferedReader(new InputStreamReader(url.openStream(), "UTF-8"));
            int i = 0;
            while ((s = br.readLine()) != null) {
                block21: {
                    try {
                        if (DEBUG_PRELOADING) {
                            logger.fine("Preloading " + s);
                        }
                        Class.forName(s, false, this);
                    }
                    catch (ClassNotFoundException e) {
                        if (DEBUG_PRELOADING) {
                            logger.log(Level.FINE, "", e);
                        }
                    }
                    catch (NoClassDefFoundError e) {
                        if (DEBUG_PRELOADING) {
                            logger.log(Level.FINE, "", e);
                        }
                    }
                    catch (Throwable e) {
                        if (!DEBUG_PRELOADING) break block21;
                        logger.log(Level.FINE, "", e);
                    }
                }
                ++i;
            }
            Bootstrap.info("Profiler: Preloaded " + i + " classes from " + this.getURLs()[0]);
        }
        catch (IOException e) {
            logger.severe("Profiler: Unable to preload classes from " + url + ". This should not be critical problem, but it may result in deadlocks", e);
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static PluginClassLoader newInstance(String jarName) throws IOException, URISyntaxException {
        Attributes attrs = PluginClassLoader.getManifestAttributes(jarName);
        String value = attrs.getValue("Entry-Points");
        if (value == null || value.length() == 0) {
            return null;
        }
        String[] entryPoints = value.split("\\s+");
        String preloadList = attrs.getValue("Preload-Classes-List");
        String dependencies = attrs.getValue("Esc-Dependencies");
        ClassLoader parentLoader = null;
        if ("instrumenter".equals(dependencies)) {
            ProfilerTransformerPlugin plugin = Bootstrap.getPlugin(ProfilerTransformerPlugin.class);
            if (plugin == null) {
                logger.severe("Plugin " + jarName + " requires instrumenter, however it was not found on the classpath. Please ensure /lib/runtime.jar exists and can be loaded.");
            } else {
                parentLoader = plugin.getClass().getClassLoader();
            }
        }
        return new PluginClassLoader(parentLoader, new URL[]{new File(jarName).toURI().toURL()}, entryPoints, preloadList);
    }

    private static Attributes getManifestAttributes(String jarName) throws IOException {
        JarFile jar = new JarFile(jarName);
        Manifest manifest = jar.getManifest();
        jar.close();
        return manifest.getMainAttributes();
    }

    public List<Object> startPlugin() throws ClassNotFoundException, InvocationTargetException, IllegalAccessException, NoSuchMethodException, InstantiationException {
        if (this.preloadList != null && this.preloadList.length() > 0) {
            this.preload(this.preloadList);
        }
        ArrayList<Object> res = new ArrayList<Object>();
        for (String entryPoint : this.entryPoints) {
            Object impl = this.loadClass(entryPoint).newInstance();
            res.add(impl);
        }
        return res;
    }
}

