/*
 * Decompiled with CFR 0.152.
 */
package com.netcracker.profiler.agent;

import com.netcracker.profiler.agent.LocalState;
import com.netcracker.profiler.agent.ProfilerData;
import com.netcracker.profiler.agent.ThreadJMXCpuProvider;
import com.netcracker.profiler.agent.TimerCache;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;

public class ThreadJMXCpu
implements ThreadJMXCpuProvider {
    private static final ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();

    @Override
    public void updateThreadCounters(LocalState state) {
        int now = TimerCache.timer;
        if (now - state.nextCpuStamp < 0) {
            return;
        }
        state.cpuTime = threadMXBean.getThreadCpuTime(state.thread.getId()) / 1000000L;
        state.nextCpuStamp = now + ProfilerData.THREAD_CPU_MINIMAL_CALL_DURATION;
    }
}

