/*
 * Decompiled with CFR 0.152.
 */
package com.netcracker.profiler.agent;

import com.netcracker.profiler.agent.LocalState;
import com.netcracker.profiler.agent.ProfilerData;
import com.netcracker.profiler.agent.ThreadJMXWaitProvider;
import com.netcracker.profiler.agent.TimerCache;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;

public class ThreadJMXWait
implements ThreadJMXWaitProvider {
    private static final ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();

    @Override
    public void updateThreadCounters(LocalState state) {
        int now = TimerCache.timer;
        if (now - state.nextWaitStamp < 0) {
            return;
        }
        ThreadInfo info = threadMXBean.getThreadInfo(state.thread.getId());
        state.waitTime = info.getWaitedTime();
        state.nextWaitStamp = now + ProfilerData.THREAD_WAIT_MINIMAL_CALL_DURATION;
    }
}

