/*
 * Decompiled with CFR 0.152.
 */
package com.netcracker.profiler.agent;

import com.netcracker.profiler.agent.ESCLogger;
import java.util.Arrays;
import java.util.concurrent.locks.LockSupport;

public class TimerCache
extends Thread {
    private static final ESCLogger logger = ESCLogger.getLogger(TimerCache.class.getName());
    public static final TimerCache instance = new TimerCache();
    public static volatile long startTime = System.currentTimeMillis();
    public static final long startTimeNano = System.nanoTime();
    public static volatile long now = startTime;
    public static volatile int timer;
    public static volatile long timerSHL32;
    public static volatile int timerWithoutSuspend;
    public static final int SUSPEND_LOG_SIZE;
    public static final int MAX_TIMER_PAUSE;
    public static final int MINIMAL_SUSPEND_TIME;
    public static final long[] suspendDates;
    public static final int[] suspendDurations;
    public static volatile int lastSuspendEvent;
    public static volatile int lastLoggedEvent;

    public TimerCache() {
        super("Timer cache thread");
        this.setDaemon(true);
        this.setPriority(10);
        this.start();
    }

    @Override
    public void run() {
        long startTime = TimerCache.startTime;
        int minimalSuspendTime = MINIMAL_SUSPEND_TIME;
        boolean suspendCalibrationRequired = false;
        if (minimalSuspendTime == -1) {
            suspendCalibrationRequired = true;
            minimalSuspendTime = 5;
        }
        long[] dates = suspendDates;
        int[] durations = suspendDurations;
        int prevTimer = 0;
        int pos = 0;
        long startWithSuspendOffset = startTime;
        int shortestObservedDeltaTime = MAX_TIMER_PAUSE;
        while (instance != null) {
            int timer;
            long now = System.currentTimeMillis();
            TimerCache.timer = timer = (int)(now - startTime);
            timerSHL32 = (long)timer << 32;
            TimerCache.now = now;
            int dt = timer - prevTimer;
            shortestObservedDeltaTime = Math.min(dt, shortestObservedDeltaTime);
            if (dt > minimalSuspendTime) {
                startWithSuspendOffset += (long)(dt - shortestObservedDeltaTime);
                dates[pos] = now;
                durations[pos] = dt;
                pos = pos == SUSPEND_LOG_SIZE ? 0 : pos + 1;
                lastSuspendEvent = pos;
            }
            timerWithoutSuspend = (int)(now - startWithSuspendOffset);
            if (suspendCalibrationRequired && (pos > 100 || timer > 10000)) {
                suspendCalibrationRequired = false;
                minimalSuspendTime = this.detectSuspendTime(minimalSuspendTime);
            }
            prevTimer = timer;
            LockSupport.parkNanos(800000L);
        }
    }

    private int detectSuspendTime(int minimalSuspendTime) {
        int numGC = lastSuspendEvent;
        int totalSuspend = timer - timerWithoutSuspend;
        int totalTime = timer;
        if (totalSuspend * 5 < totalTime) {
            logger.fine("Profiler: all the durations exceeding " + minimalSuspendTime + "ms will be charged to suspension");
            return minimalSuspendTime;
        }
        int[] dt = new int[numGC];
        System.arraycopy(suspendDurations, 0, dt, 0, Math.min(suspendDurations.length, dt.length));
        Arrays.sort(dt);
        --numGC;
        while (numGC >= 0 && dt[numGC] > MAX_TIMER_PAUSE) {
            totalSuspend -= dt[numGC];
            totalTime -= dt[numGC];
            --numGC;
        }
        int numBigPauses = dt.length - 1 - numGC;
        if (numGC == -1) {
            logger.fine("Profiler: all the suspension events lasted more than expected " + MAX_TIMER_PAUSE + "ms (MAX_TIMER_PAUSE). Assuming " + numBigPauses + " (all) of them " + (numBigPauses == 1 ? "is" : "are") + " related to abnormal pauses (the fastest was " + dt[numGC + 1] + "ms, the slowest was " + dt[dt.length - 1] + "ms).");
        } else {
            if (numGC < dt.length - 1) {
                logger.fine("Profiler: assuming pauses longer than " + MAX_TIMER_PAUSE + "ms (MAX_TIMER_PAUSE) are caused by gc/swap. Assuming " + numBigPauses + " of them " + (numBigPauses == 1 ? "is" : "are") + " related to abnormal pauses (the fastest was " + dt[numGC + 1] + "ms, the slowest was " + dt[dt.length - 1] + "ms).");
            }
            int i = 0;
            while (totalSuspend * 20 > totalTime && i < numGC) {
                minimalSuspendTime = dt[i];
                while (i < numGC && dt[i] <= minimalSuspendTime) {
                    totalSuspend -= dt[i];
                    ++i;
                }
            }
        }
        logger.fine("Profiler: all the durations exceeding " + (minimalSuspendTime *= 2) + "ms will be charged to suspension");
        return minimalSuspendTime;
    }

    public static void main(String[] args) throws InterruptedException {
        instance.getId();
        Thread.sleep(150000L);
    }

    static {
        SUSPEND_LOG_SIZE = Integer.getInteger(TimerCache.class.getName() + ".SUSPEND_LOG_SIZE", 3600) - 1;
        MAX_TIMER_PAUSE = Integer.getInteger(TimerCache.class.getName() + ".MAX_TIMER_PAUSE", 50);
        MINIMAL_SUSPEND_TIME = Integer.getInteger(TimerCache.class.getName() + ".MINIMAL_SUSPEND_TIME", -1);
        suspendDates = new long[SUSPEND_LOG_SIZE + 1];
        suspendDurations = new int[SUSPEND_LOG_SIZE + 1];
        lastSuspendEvent = 0;
        lastLoggedEvent = 0;
    }
}

