/*
 * Decompiled with CFR 0.152.
 */
package com.netcracker.profiler.agent;

import com.netcracker.profiler.agent.ProfilerData;
import com.netcracker.profiler.agent.PropertyFacadeBoot;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.text.MessageFormat;
import java.util.Date;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;

public class ESCLogger {
    private static final String MESSAGE_FORMAT_STRING_DEFAULT = "{3,date,YYYY-MM-dd HH:mm:ss,SSS}  {1} [thread={2}] [class={0}]- {4}{5}";
    private static final String MESSAGE_FORMAT_STRING = PropertyFacadeBoot.getProperty(ESCLogger.class.getName() + ".format", "{3,date,YYYY-MM-dd HH:mm:ss,SSS}  {1} [thread={2}] [class={0}]- {4}{5}");
    private static final MessageFormat MESSAGE_FORMAT = new MessageFormat(MESSAGE_FORMAT_STRING);
    public static Level ESC_LOG_LEVEL;
    private String name;
    private final Level logLevel;
    private static boolean javaUtilLoggingEnabled;
    private static Runnable corruptedBufferCallback;
    private static AtomicInteger numCorruptions;

    public ESCLogger(String name) {
        this(name, ESC_LOG_LEVEL);
    }

    public ESCLogger(String name, Level logLevel) {
        this.name = name;
        this.logLevel = logLevel;
    }

    static void enableJavaUtilLogging() {
        System.out.println("Enabling java.util.logging");
        javaUtilLoggingEnabled = true;
    }

    public static boolean isJavaUtilLoggingEnabled() {
        return javaUtilLoggingEnabled;
    }

    public static ESCLogger getLogger(Class clazz) {
        return ESCLogger.getLogger(clazz.getName());
    }

    public static ESCLogger getLogger(String className) {
        return new ESCLogger(className);
    }

    public static ESCLogger getLogger(Class clazz, Level logLevel) {
        return ESCLogger.getLogger(clazz.getName(), logLevel);
    }

    public static ESCLogger getLogger(String className, Level logLevel) {
        return new ESCLogger(className, logLevel);
    }

    public void severe(String message) {
        this.log(Level.SEVERE, message, null);
    }

    public void severe(String message, Throwable t) {
        this.log(Level.SEVERE, message, t);
    }

    public void info(String message) {
        this.log(Level.INFO, message, null);
    }

    public void fine(String message) {
        this.log(Level.FINE, message, null);
    }

    public void warning(String message) {
        this.log(Level.WARNING, message, null);
    }

    public void corruptedBufferWarning(String message) {
        this.corruptedBufferWarning(message, null);
    }

    public void reportDirtyBufferOverflow(String threadName) {
        numCorruptions.incrementAndGet();
    }

    public void printDirtyBufferWarningInCaseOfOverflow() {
        int numOverflows = numCorruptions.getAndSet(0);
        if (numOverflows > 0) {
            this.corruptedBufferWarning("ESCAGENTCORRUPTEDBUFFER: " + numOverflows + " buffers could not be sent to remote collector and have been discarded");
        }
    }

    public void corruptedBufferWarning(String message, Throwable t) {
        if (ProfilerData.warnBufferQueueOverflow) {
            this.log(Level.WARNING, message, t);
        } else {
            this.log(Level.FINE, message, t);
        }
        if (corruptedBufferCallback != null) {
            corruptedBufferCallback.run();
        }
    }

    public static void setCorruptedBufferCallback(Runnable callback) {
        corruptedBufferCallback = callback;
    }

    public boolean isFineEnabled() {
        return Level.FINE.intValue() >= this.logLevel.intValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void log(Level level, String message, Throwable t) {
        String toPrint;
        if (level.intValue() < this.logLevel.intValue()) {
            return;
        }
        Object[] arguments = new Object[6];
        arguments[0] = this.name;
        arguments[1] = level;
        arguments[2] = Thread.currentThread().getName();
        arguments[3] = new Date();
        arguments[4] = message;
        if (t != null) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            t.printStackTrace(new PrintStream(byteArrayOutputStream));
            arguments[5] = "\n" + byteArrayOutputStream.toString();
        } else {
            arguments[5] = "";
        }
        MessageFormat messageFormat = MESSAGE_FORMAT;
        synchronized (messageFormat) {
            toPrint = MESSAGE_FORMAT.format(arguments);
        }
        if (Level.SEVERE.equals(level) || Level.WARNING.equals(level)) {
            System.err.println(toPrint);
        } else {
            System.out.println(toPrint);
        }
    }

    static {
        numCorruptions = new AtomicInteger(0);
        String logLevelProperty = PropertyFacadeBoot.getPropertyOrEnvVariable("ESC_LOG_LEVEL");
        if (logLevelProperty == null) {
            ESC_LOG_LEVEL = Level.WARNING;
        } else if ("debug".equalsIgnoreCase(logLevelProperty.trim())) {
            ESC_LOG_LEVEL = Level.FINE;
        } else {
            try {
                ESC_LOG_LEVEL = Level.parse(logLevelProperty);
            }
            catch (Throwable t) {
                ESC_LOG_LEVEL = Level.WARNING;
            }
        }
    }
}

