/*
 * Decompiled with CFR 0.152.
 */
package com.netcracker.profiler.agent;

import com.netcracker.profiler.agent.CallInfo;
import com.netcracker.profiler.agent.ESCLogger;
import com.netcracker.profiler.agent.LocalBuffer;
import com.netcracker.profiler.agent.ProfilerAgentException;
import com.netcracker.profiler.agent.ProfilerData;
import com.netcracker.profiler.agent.StringUtils;
import com.netcracker.profiler.agent.ThreadJMXProvider;
import com.netcracker.profiler.agent.ThreadJMXProviderFactory;
import com.netcracker.profiler.agent.TimerCache;

public class LocalState {
    private static final ESCLogger logger = ESCLogger.getLogger(LocalState.class.getName());
    private static final ThreadJMXProvider THREAD_INFO_PROVIDER = ThreadJMXProviderFactory.INSTANCE;
    public final Thread thread = Thread.currentThread();
    public final int dumperIncarnation = ProfilerData.dumperIncarnation;
    public LocalBuffer buffer;
    private long largeEventsVolume;
    public int sp;
    public CallInfo callInfo = new CallInfo(this);
    public final String shortThreadName = LocalState.getShortThreadName(this.thread.getName());
    public long[] stackTrace = ProfilerData.MINIMAL_LOGGED_DURATION == 0 ? null : new long[ProfilerData.INITIAL_STACK_LENGTH];
    private int flushedSp;
    public boolean isSystem;
    public long cpuTime;
    public long waitTime;
    public long memoryUsed;
    public long fileRead;
    public long fileWritten;
    public long netRead;
    public long netWritten;
    public long transactions;
    public int nextCpuStamp = TimerCache.timer + ProfilerData.THREAD_CPU_MINIMAL_CALL_DURATION;
    public int nextWaitStamp = TimerCache.timer + ProfilerData.THREAD_WAIT_MINIMAL_CALL_DURATION;
    public int nextMemoryStamp = TimerCache.timer + ProfilerData.THREAD_MEMORY_MINIMAL_CALL_DURATION;
    private boolean isTriggeredAddingInformationToLocalBuffer = false;
    public Object additional;

    public void enter(int methodId) {
        long methodAndTime = (long)methodId | TimerCache.timerSHL32;
        this.enter(methodAndTime);
    }

    public void enter(int methodId, long millisecondsPassed) {
        long startTimeToReportSHL32;
        if (millisecondsPassed > 0L) {
            this.callInfo.additionalReportedTime += (int)millisecondsPassed;
            startTimeToReportSHL32 = (long)TimerCache.timer - millisecondsPassed << 32;
        } else {
            startTimeToReportSHL32 = TimerCache.timerSHL32;
        }
        long methodAndTime = (long)methodId | startTimeToReportSHL32;
        this.enter(methodAndTime);
    }

    public void enter(long methodAndTime) {
        if (ProfilerData.MINIMAL_LOGGED_DURATION == 0) {
            this.logEnterImmediately(methodAndTime);
        } else {
            this.logEnterLazy(methodAndTime);
        }
    }

    public void exit() {
        if (ProfilerData.MINIMAL_LOGGED_DURATION == 0) {
            this.logExitImmediately();
        } else {
            this.logExitLazy();
        }
    }

    public void event(Object value, int id) {
        if (ProfilerData.MINIMAL_LOGGED_DURATION == 0) {
            this.logEventImmediately(value, id);
        } else {
            this.logEventLazy(value, id);
        }
    }

    public boolean reserveLargeEventVolume(long volume) {
        long largeEventsVolume = this.largeEventsVolume + volume;
        if (largeEventsVolume < (long)ProfilerData.LARGE_EVENT_TLAB_BYTES) {
            this.largeEventsVolume = largeEventsVolume;
            return true;
        }
        if (ProfilerData.reserveLargeEventVolume(largeEventsVolume)) {
            this.largeEventsVolume = 0L;
            return true;
        }
        return false;
    }

    private void logEnterImmediately(int methodId) {
        ++this.sp;
        this.buffer.initEnter(methodId);
    }

    private void logEnterImmediately(long methodAndTime) {
        if (this.isTriggeredAddingInformationToLocalBuffer) {
            return;
        }
        this.isTriggeredAddingInformationToLocalBuffer = true;
        try {
            ++this.sp;
            this.buffer.initEnter(methodAndTime);
        }
        finally {
            this.isTriggeredAddingInformationToLocalBuffer = false;
        }
    }

    private void logExitImmediately() {
        if (this.isTriggeredAddingInformationToLocalBuffer) {
            return;
        }
        this.isTriggeredAddingInformationToLocalBuffer = true;
        try {
            int sp = this.sp;
            this.sp = --sp;
            if (sp == 0) {
                this.callFinished();
                return;
            }
            if (sp < 0) {
                throw new ProfilerAgentException("SP is below zero. this should never happen: " + sp);
            }
            this.buffer.initExit();
        }
        finally {
            this.isTriggeredAddingInformationToLocalBuffer = false;
        }
    }

    private void logEventImmediately(Object value, int id) {
        if (this.isTriggeredAddingInformationToLocalBuffer) {
            return;
        }
        this.isTriggeredAddingInformationToLocalBuffer = true;
        try {
            this.buffer.event(value, id);
        }
        finally {
            this.isTriggeredAddingInformationToLocalBuffer = false;
        }
    }

    private void logEnterLazy(int methodId) {
        long methodAndTime = (long)methodId | TimerCache.timerSHL32;
        this.logEnterLazy(methodAndTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logEnterLazy(long methodAndTime) {
        if (this.isTriggeredAddingInformationToLocalBuffer) {
            return;
        }
        this.isTriggeredAddingInformationToLocalBuffer = true;
        try {
            int sp = this.sp;
            this.sp = sp + 1;
            long[] stackTrace = this.stackTrace;
            if (sp >= 0 && sp < stackTrace.length) {
                stackTrace[sp] = methodAndTime;
            } else {
                this.growStackTrace(methodAndTime);
            }
        }
        finally {
            this.isTriggeredAddingInformationToLocalBuffer = false;
        }
    }

    private void growStackTrace(int methodId) {
        this.growStackTrace((long)methodId | TimerCache.timerSHL32);
    }

    private void growStackTrace(long methodAndTime) {
        long[] newStack = new long[this.stackTrace.length * 2];
        System.arraycopy(this.stackTrace, 0, newStack, 0, this.stackTrace.length);
        newStack[this.sp - 1] = methodAndTime;
        this.stackTrace = newStack;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logExitLazy() {
        if (this.isTriggeredAddingInformationToLocalBuffer) {
            return;
        }
        this.isTriggeredAddingInformationToLocalBuffer = true;
        try {
            int sp = this.sp;
            if (this.flushedSp == sp) {
                this.logExitFromStack();
                return;
            }
            this.sp = --sp;
            if (sp == 0) {
                this.callFinishedLazy();
                return;
            }
            if (sp < 0) {
                throw new ProfilerAgentException("SP is below zero. this should never happen: " + sp);
            }
            int timer = TimerCache.timer;
            int start = (int)(this.stackTrace[sp] >>> 32);
            if (timer < start + ProfilerData.MINIMAL_LOGGED_DURATION) {
                return;
            }
            this.logStackTrace();
            this.buffer.initTimedEnter(this.stackTrace[sp]);
            this.buffer.initExit();
        }
        finally {
            this.isTriggeredAddingInformationToLocalBuffer = false;
        }
    }

    private void logStackTrace() {
        while (this.flushedSp < this.sp) {
            this.buffer.initTimedEnter(this.stackTrace[this.flushedSp]);
            ++this.flushedSp;
        }
    }

    private void logExitFromStack() {
        int sp = this.sp;
        this.sp = --sp;
        if (sp == 0) {
            this.callFinishedLazy();
            return;
        }
        if (sp < 0) {
            throw new ProfilerAgentException("SP is below zero. this should never happen: " + sp);
        }
        this.flushedSp = sp;
        this.buffer.initExit();
    }

    private void logEventLazy(Object value, int id) {
        if (this.isTriggeredAddingInformationToLocalBuffer) {
            return;
        }
        this.isTriggeredAddingInformationToLocalBuffer = true;
        try {
            this.logStackTrace();
            this.buffer.event(value, id);
        }
        finally {
            this.isTriggeredAddingInformationToLocalBuffer = false;
        }
    }

    private void callFinishedLazy() {
        if (this.flushedSp == 0) {
            int timer = TimerCache.timer;
            int start = (int)(this.stackTrace[0] >>> 32);
            if (timer < start + ProfilerData.MINIMAL_LOGGED_DURATION) {
                CallInfo prev = this.callInfo;
                prev.finishTime = timer;
                this.callInfo = new CallInfo(this);
                this.createNewMass();
                return;
            }
            this.buffer.initTimedEnter(this.stackTrace[0]);
        }
        this.flushedSp = 0;
        this.callFinished();
        this.createNewMass();
    }

    private void createNewMass() {
        if (this.stackTrace.length > ProfilerData.MAX_STACK_LENGTH) {
            this.stackTrace = new long[ProfilerData.INITIAL_STACK_LENGTH];
        }
    }

    private void callFinished() {
        if (this.buffer.corrupted) {
            this.buffer.init(null);
            this.buffer.corrupted = false;
            if (logger.isFineEnabled()) {
                logger.fine("ESCAGENTCORRUPTEDBUFFER: resetting corrupted state to false for active buffer of thread " + this.thread.getName());
            }
            this.additional = null;
            this.callInfo = null;
            this.callInfo = new CallInfo(this);
            return;
        }
        THREAD_INFO_PROVIDER.updateThreadCounters(this);
        CallInfo callInfo = this.callInfo;
        callInfo.cpuTime = this.cpuTime;
        callInfo.waitTime = this.waitTime;
        callInfo.memoryUsed = this.memoryUsed;
        callInfo.fileRead = this.fileRead;
        callInfo.fileWritten = this.fileWritten;
        callInfo.netRead = this.netRead;
        callInfo.netWritten = this.netWritten;
        callInfo.transactions = this.transactions;
        callInfo.finishTime = TimerCache.timer;
        this.buffer.event(callInfo, ProfilerData.PARAM_CALL_INFO);
        CallInfo prev = this.callInfo;
        prev.next = this.callInfo = new CallInfo(this);
    }

    public void markSystem() {
        this.isSystem = true;
    }

    private static String getShortThreadName(String fullName) {
        int executeThread = fullName.indexOf("ExecuteThread: ");
        if (executeThread >= 0) {
            fullName = fullName.substring(executeThread + 16);
        } else if ((fullName.endsWith("_MisfireHandler") || fullName.endsWith("_ClusterManager")) && fullName.length() > 25) {
            fullName = fullName.substring(fullName.length() - 25);
        } else if (fullName.startsWith("QuartzScheduler")) {
            fullName = "Quartz" + fullName.substring("QuartzScheduler".length());
        } else if (fullName.startsWith("DataFlow")) {
            fullName = "DF" + fullName.substring("DataFlow".length());
        }
        return fullName;
    }

    public String toString() {
        return "LocalState{" + System.identityHashCode(this) + " thread=" + this.thread + ", dumperIncarnation=" + this.dumperIncarnation + ", sp=" + this.sp + ", callInfo=" + this.callInfo + ", shortThreadName='" + this.shortThreadName + '\'' + ", flushedSp=" + this.flushedSp + ", isSystem=" + this.isSystem + ", cpuTime=" + this.cpuTime + ", waitTime=" + this.waitTime + ", memoryUsed=" + this.memoryUsed + ", fileRead=" + this.fileRead + ", fileWritten=" + this.fileWritten + ", netRead=" + this.netRead + ", netWritten=" + this.netWritten + ", transactions=" + this.transactions + ", nextCpuStamp=" + this.nextCpuStamp + ", nextWaitStamp=" + this.nextWaitStamp + ", nextMemoryStamp=" + this.nextMemoryStamp + ", additional=" + this.additional + ", stackTrace=" + StringUtils.arrayToString(new StringBuilder(), this.stackTrace) + ", buffer=" + this.buffer + '}';
    }
}

