/*
 * Decompiled with CFR 0.152.
 */
package com.netcracker.profiler.agent;

import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;

public class MetricsDescription {
    private String name;
    private Map<String, String> parameters = new HashMap<String, String>();

    public MetricsDescription(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public void setParameter(String key, String value) {
        this.parameters.put(key, value);
    }

    public void print(PrintWriter out) {
        if (this.name == null) {
            return;
        }
        out.println(this.name);
        if (this.parameters == null) {
            out.println("No params");
            return;
        }
        for (Map.Entry<String, String> param : this.parameters.entrySet()) {
            out.println(param.getKey() + " " + param.getValue());
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetricsDescription that = (MetricsDescription)o;
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        return this.parameters != null ? this.parameters.equals(that.parameters) : that.parameters == null;
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.parameters != null ? this.parameters.hashCode() : 0);
        return result;
    }
}

