/*
 * Decompiled with CFR 0.152.
 */
package com.netcracker.profiler.agent;

import com.netcracker.profiler.agent.ESCLogger;
import com.netcracker.profiler.agent.LocalState;
import com.netcracker.profiler.agent.ProfilerData;
import com.netcracker.profiler.agent.ThreadJMXMemoryProvider;
import com.netcracker.profiler.agent.TimerCache;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.logging.Level;

public class ThreadJMXMemory
implements ThreadJMXMemoryProvider {
    private static boolean DEBUG = Boolean.getBoolean(ThreadJMXMemory.class.getName() + ".debug");
    private static final ESCLogger logger = ESCLogger.getLogger(ThreadJMXMemory.class, DEBUG ? Level.FINE : ESCLogger.ESC_LOG_LEVEL);
    private static final ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
    private static final Method getThreadAllocatedBytes;

    @Override
    public void updateThreadCounters(LocalState state) {
        int now;
        block5: {
            now = TimerCache.timer;
            if (now - state.nextMemoryStamp < 0) {
                return;
            }
            try {
                state.memoryUsed = (Long)getThreadAllocatedBytes.invoke((Object)threadMXBean, state.thread.getId());
            }
            catch (IllegalAccessException e) {
                if (DEBUG) {
                    logger.log(Level.FINE, "", e);
                }
            }
            catch (InvocationTargetException e) {
                if (!DEBUG) break block5;
                logger.log(Level.FINE, "", e);
            }
        }
        state.nextMemoryStamp = now + ProfilerData.THREAD_MEMORY_MINIMAL_CALL_DURATION;
    }

    static {
        try {
            getThreadAllocatedBytes = threadMXBean.getClass().getMethod("getThreadAllocatedBytes", Long.TYPE);
            getThreadAllocatedBytes.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("Unable to initialize ThreadJMXMemory provider", e);
        }
    }
}

