/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.client;

import java.io.IOException;
import java.io.OutputStream;
import org.qubership.profiler.agent.DumperCollectorClient;
import org.qubership.profiler.agent.DumperRemoteControlledStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RollingChunkStream
extends OutputStream
implements DumperRemoteControlledStream {
    private static final Logger log = LoggerFactory.getLogger(RollingChunkStream.class);
    private final int rollingSequenceId;
    private final String streamName;
    private final long rotationPeriod;
    private final long requiredRotationSize;
    private final DumperCollectorClient collectorClient;

    public RollingChunkStream(int rollingSequenceId, String streamName, long rotationPeriod, long requiredRotationSize, DumperCollectorClient collectorClient) {
        this.rollingSequenceId = rollingSequenceId;
        this.streamName = streamName;
        this.rotationPeriod = rotationPeriod;
        this.requiredRotationSize = requiredRotationSize;
        this.collectorClient = collectorClient;
    }

    public String getStreamName() {
        return this.streamName;
    }

    public long getRotationPeriod() {
        return this.rotationPeriod;
    }

    public long getRequiredRotationSize() {
        return this.requiredRotationSize;
    }

    public int getRollingSequenceId() {
        return this.rollingSequenceId;
    }

    @Override
    public void write(byte[] bytes, int offset, int length) throws IOException {
        this.collectorClient.write(bytes, offset, length, this.getStreamName());
    }

    @Override
    public void write(int word) throws IOException {
        this.write(new byte[]{(byte)word});
    }

    @Override
    public void write(byte[] bytes) throws IOException {
        this.write(bytes, 0, bytes.length);
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public void flush() throws IOException {
        this.collectorClient.flush();
    }

    public OutputStream getOutputStream() {
        return this;
    }

    public DumperCollectorClient getClient() {
        return this.collectorClient;
    }
}

