/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.dump;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OldLogPruner
implements Runnable {
    public static final Logger log = LoggerFactory.getLogger(OldLogPruner.class);
    long maxFileTimestamp;
    long maxSize;
    long size;
    File root;
    static final FileFilter DIRECTORY_FINDER = new FileFilter(){

        @Override
        public boolean accept(File pathname) {
            return pathname.isDirectory();
        }
    };
    static final Comparator<File> ORDER_BY_LAST_MODIFIED_DESC = new Comparator<File>(){

        @Override
        public int compare(File a, File b) {
            long y;
            long x = a.lastModified();
            if (x < (y = b.lastModified())) {
                return 1;
            }
            if (x > y) {
                return -1;
            }
            return 0;
        }
    };

    public OldLogPruner(long maxAge, long maxSize, File root) {
        this.maxFileTimestamp = System.currentTimeMillis() - maxAge;
        this.maxSize = maxSize;
        this.root = root;
    }

    @Override
    public void run() {
        this.findInFolder(this.root, 0);
        log.info("Total space used by profiler log files after purge is {} Mb", (Object)(this.size / 1024L / 1024L));
    }

    private void findInFolder(File root, int level) {
        if (level == 4) {
            ArrayList<File> files = new ArrayList<File>();
            this.addFiles(files, root, "trace");
            this.addFiles(files, root, "xml");
            this.addFiles(files, root, "sql");
            Collections.sort(files, ORDER_BY_LAST_MODIFIED_DESC);
            for (File file : files) {
                if (this.size <= this.maxSize && file.lastModified() >= this.maxFileTimestamp) {
                    this.size += file.length();
                    continue;
                }
                OldLogPruner.deleteFile(file);
            }
            if (!files.isEmpty()) {
                files.clear();
                this.addFiles(files, root, "trace");
            }
            if (files.isEmpty()) {
                OldLogPruner.deleteFile(root);
            }
            return;
        }
        if (root.isDirectory()) {
            File[] files = root.listFiles(DIRECTORY_FINDER);
            Arrays.sort(files, Collections.reverseOrder());
            for (File f : files) {
                if (this.size <= this.maxSize) {
                    this.findInFolder(f, level + 1);
                    continue;
                }
                OldLogPruner.deleteFile(f);
            }
        }
    }

    private void addFiles(ArrayList<File> files, File root, String subfolder) {
        File callsFolder = new File(root, subfolder);
        if (!callsFolder.exists()) {
            return;
        }
        files.addAll(Arrays.asList(callsFolder.listFiles()));
    }

    public static boolean deleteFile(File path) {
        log.info("Deleting {} {}", (Object)(path.isDirectory() ? "directory with subdirectories" : "file"), (Object)path);
        if (path.exists() && path.isDirectory()) {
            OldLogPruner.deleteSubDirectories(path);
        }
        return path.delete();
    }

    public static boolean deleteSubDirectories(File path) {
        if (path.exists() && path.isDirectory()) {
            for (File file : path.listFiles()) {
                OldLogPruner.deleteSubDirectories(file);
            }
        }
        return path.delete();
    }
}

