/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.metrics;

import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.qubership.profiler.agent.MetricType;
import org.qubership.profiler.metrics.AbstractMetric;
import org.qubership.profiler.metrics.AggregationParameter;
import org.qubership.profiler.metrics.MetricUnit;

public class CountMetric
extends AbstractMetric {
    private static final MetricType METRIC_TYPE = MetricType.COUNT;
    private static final MetricUnit METRIC_UNIT = MetricUnit.TOTAL;
    private AtomicLong count = new AtomicLong();

    public CountMetric(String callType, HashSet<AggregationParameter> aggregationParameters, int outputVersion) {
        super(callType, METRIC_TYPE, aggregationParameters, METRIC_UNIT, outputVersion);
    }

    public void recordValue(long value, Map<String, Object> params) {
        this.count.incrementAndGet();
    }

    public void resetValue() {
        this.count.set(0L);
    }

    public void print(StringBuilder out) {
        out.append(this.key).append("} ").append(this.count).append("\n");
    }
}

