/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.metrics;

import java.util.HashSet;
import java.util.Map;
import org.qubership.profiler.agent.CallInfo;
import org.qubership.profiler.agent.MetricType;
import org.qubership.profiler.dump.ThreadState;
import org.qubership.profiler.metrics.AbstractHistogramMetric;
import org.qubership.profiler.metrics.AggregationParameter;
import org.qubership.profiler.metrics.MetricUnit;

public class MemoryMetric
extends AbstractHistogramMetric {
    private final long DEFAULT_VALUE_UNITS_IN_FIRST_BUCKET = 1024L;
    private final long DEFAULT_LOWEST_DISCERNIBLE_VALUE = 1024L;
    private final long DEFAULT_HIGHEST_TRACKABLE_VALUE = 1000000000L;
    private static final MetricType METRIC_TYPE = MetricType.MEMORY;
    private static final MetricUnit METRIC_UNIT = MetricUnit.KILOBYTES;

    public MemoryMetric(String callType, HashSet<AggregationParameter> aggregationParameters, Map<String, String> metricParameters, int outputVersion) {
        super(callType, METRIC_TYPE, aggregationParameters, METRIC_UNIT, outputVersion, "bucket");
        this.valueUnitsInFirstBucket = 1024L;
        this.lowestDiscernibleValue = 1024L;
        this.highestTrackableValue = 1000000000L;
        this.parseHistogramParameters(metricParameters);
        this.initHistogram();
    }

    public void recordValue(long value, Map<String, Object> params) {
        CallInfo callInfo = (CallInfo)params.get("callInfo");
        ThreadState threadState = (ThreadState)params.get("threadState");
        long memoryUsed = callInfo.memoryUsed - threadState.prevMemoryUsed;
        this.recordValue(memoryUsed / 1024L);
    }
}

