/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.stream;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.zip.GZIPOutputStream;
import org.qubership.profiler.agent.DumperCollectorClient;
import org.qubership.profiler.cloud.transport.ProfilerProtocolException;
import org.qubership.profiler.dump.DataOutputStreamEx;
import org.qubership.profiler.dump.DumpFile;
import org.qubership.profiler.dump.FlushableGZIPOutputStream;
import org.qubership.profiler.dump.IDataOutputStreamEx;
import org.qubership.profiler.exception.ProfilerAgentIOException;
import org.qubership.profiler.io.RemoteAndLocalOutputStream;
import org.qubership.profiler.io.listener.FileRotatedListener;
import org.qubership.profiler.stream.ICompressedLocalAndRemoteOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompressedLocalAndRemoteOutputStream
implements ICompressedLocalAndRemoteOutputStream {
    public static final Logger log = LoggerFactory.getLogger(CompressedLocalAndRemoteOutputStream.class);
    private static boolean isGZIPOutputStreamSyncFlushSupported;
    final NumberFormat fileIndexFormat = NumberFormat.getIntegerInstance();
    private File root;
    private final String name;
    private RemoteAndLocalOutputStream remote;
    private ICompressedLocalAndRemoteOutputStream sequenceSource;
    private int rotateThreshold;
    private long uncompressedSize;
    private long compressedSize;
    private DumperCollectorClient client;
    private boolean rotateForRemote;
    private long lastRotatedMillis;
    private boolean localDumpEnabled;
    int index;
    DataOutputStreamEx stream;
    File currentFile;
    int version;
    private ICompressedLocalAndRemoteOutputStream dependentStream;
    private List<FileRotatedListener> fileRotatedListeners;
    private Object state;

    @Override
    public void setLocalDumpEnabled(boolean localDumpEnabled) {
        this.localDumpEnabled = localDumpEnabled;
    }

    public CompressedLocalAndRemoteOutputStream(String name, int rotateThreshold, int version) {
        this(name, rotateThreshold, version, null);
    }

    public CompressedLocalAndRemoteOutputStream(String name, int rotateThreshold, int version, Object state) {
        this.fileIndexFormat.setGroupingUsed(false);
        this.fileIndexFormat.setMinimumIntegerDigits(6);
        this.rotateForRemote = false;
        this.rotateThreshold = rotateThreshold;
        this.name = name;
        this.version = version;
        this.state = state;
    }

    @Override
    public void askRotateForRemote() {
        this.rotateForRemote = true;
    }

    protected boolean resetExistingContents() {
        return false;
    }

    private RemoteAndLocalOutputStream getRemote(int requestedRollingSequenceId) throws IOException {
        RemoteAndLocalOutputStream stream = new RemoteAndLocalOutputStream(this.client, this.name, requestedRollingSequenceId, this.localDumpEnabled, this.resetExistingContents());
        this.rotateForRemote = false;
        return stream;
    }

    @Override
    public IDataOutputStreamEx getStream() {
        return this.stream;
    }

    @Override
    public void writePhrase() throws IOException {
        if (this.remote != null) {
            this.remote.writePhrase();
        }
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public ICompressedLocalAndRemoteOutputStream setRoot(File root) {
        this.root = root;
        this.initialize();
        return this;
    }

    protected void initialize() {
        this.index = this.sequenceSource == null ? 0 : this.sequenceSource.getIndex();
    }

    @Override
    public void setClient(DumperCollectorClient client) {
        this.client = client;
    }

    @Override
    public CompressedLocalAndRemoteOutputStream rotate() throws IOException {
        this.index = this.sequenceSource == null ? this.index + 1 : this.sequenceSource.getIndex();
        this.stream = this.rotateStream();
        if (this.version != 0) {
            this.stream.writeLong(0xFFFEFDFC00000000L | (long)this.version);
        }
        this.fileRotated();
        return this;
    }

    @Override
    public void fileRotated() throws IOException {
    }

    private DataOutputStreamEx rotateStream() throws IOException {
        RemoteAndLocalOutputStream result = null;
        File oldFile = this.currentFile;
        this.close();
        if (this.client != null) {
            int requestedRollingSequenceId = this.index - 1;
            this.remote = this.getRemote(requestedRollingSequenceId);
            int indexFromRemote = this.remote.getRollingSequenceId() + 1;
            log.debug("Rotated stream {}. New Local index: {}, new remote index: {}", new Object[]{this.name, this.index, indexFromRemote});
            if (this.sequenceSource != null && this.sequenceSource.getIndex() != indexFromRemote) {
                throw new ProfilerProtocolException("Failed to align sequences of stream " + this.name + " and its parent stream " + this.sequenceSource.getName());
            }
            this.index = indexFromRemote;
            result = this.remote;
            log.debug("Created dump buffers for local and remote for {} / {}", (Object)this.name, (Object)this.index);
        }
        if (this.localDumpEnabled) {
            String rollingSequenceId = this.fileIndexFormat.format(this.index);
            String fileName = this.name + File.separatorChar + rollingSequenceId + ".gz";
            log.debug("Opening new {} file", (Object)fileName);
            File newFile = new File(this.root, fileName);
            File parentFile = newFile.getParentFile();
            if (!parentFile.exists()) {
                log.debug("Creating directory {}", (Object)parentFile.getAbsolutePath());
                if (!parentFile.mkdirs()) {
                    log.error("Unable to create directory {}", (Object)parentFile.getAbsolutePath());
                }
            }
            this.currentFile = newFile;
            this.notifyFileRotated(oldFile, newFile, this.dependentStream == null ? null : this.dependentStream.getCurrentFile());
            Object local = isGZIPOutputStreamSyncFlushSupported ? new GZIPOutputStream((OutputStream)new FileOutputStream(newFile), 1024, true) : new FlushableGZIPOutputStream((OutputStream)new FileOutputStream(newFile), 1024);
            if (this.remote == null) {
                result = local;
                log.debug("Skipped remote collector stream creation, local buffer size {}", (Object)1024);
            } else {
                this.remote.setLocal((OutputStream)local);
            }
        }
        if (result == null) {
            throw new ProfilerAgentIOException("Cannot write anywhere, both local and remote dumps are disabled.");
        }
        this.lastRotatedMillis = System.currentTimeMillis();
        return new DataOutputStreamEx(result);
    }

    private void notifyFileRotated(File oldFile, File newFile, File dependentFile) {
        if (this.fileRotatedListeners == null) {
            return;
        }
        for (FileRotatedListener listener : this.fileRotatedListeners) {
            DumpFile dependentDF = dependentFile == null ? null : new DumpFile(dependentFile.getPath(), -1L, -1L);
            DumpFile oldDF = oldFile == null ? null : new DumpFile(oldFile.getPath(), oldFile.length(), oldFile.lastModified(), dependentDF);
            DumpFile newDF = newFile == null ? null : new DumpFile(newFile.getPath(), newFile.length(), newFile.lastModified());
            listener.fileRotated(oldDF, newDF);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.stream == null) {
            return;
        }
        try {
            this.stream.close();
        }
        catch (Exception e) {
            log.error("Failed to close previous stream " + this.name + " during rotation. Will continue rotation anyway", (Throwable)e);
        }
        this.uncompressedSize += (long)this.stream.size();
        this.compressedSize += this.localDumpEnabled ? this.currentFile.length() : 1L;
        this.stream = null;
        this.currentFile = null;
    }

    private boolean rotationPeriodPassed() {
        if (this.remote == null) {
            return false;
        }
        long rotationPeriod = this.remote.getRotationPeriod();
        long sinceLastRotation = System.currentTimeMillis() - this.lastRotatedMillis;
        return rotationPeriod > 0L && sinceLastRotation > rotationPeriod;
    }

    @Override
    public boolean rotateIfRequired() throws IOException {
        boolean rotationBySizeRequired;
        boolean rotationPeriodPassed = this.rotationPeriodPassed();
        long rotationSizeThreshold = Math.min(this.rotateThreshold <= 0 ? Long.MAX_VALUE : (long)this.rotateThreshold, this.remote == null || this.remote.getRequiredRotationSize() <= 0L ? Long.MAX_VALUE : this.remote.getRequiredRotationSize());
        boolean bl = rotationBySizeRequired = rotationSizeThreshold != Long.MAX_VALUE && this.stream != null && (long)this.stream.size() > rotationSizeThreshold;
        if (!(this.rotateForRemote || rotationPeriodPassed || rotationBySizeRequired)) {
            return false;
        }
        log.debug("Rotating stream {}. Size {}. size threshold {}. Rotation by size {}, rotation by time {}. for remote {}", new Object[]{this.name, this.stream == null ? null : Integer.valueOf(this.stream.size()), rotationSizeThreshold, rotationBySizeRequired, rotationPeriodPassed, this.rotateForRemote});
        this.rotate();
        return true;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public long getUncompressedSize() {
        return this.uncompressedSize + (long)(this.stream == null ? 0 : this.stream.size());
    }

    @Override
    public long getCompressedSize() {
        return this.compressedSize + (long)(this.stream == null ? 0 : this.stream.size() / 20);
    }

    @Override
    public void addListener(FileRotatedListener listener) {
        if (this.fileRotatedListeners == null) {
            this.fileRotatedListeners = new ArrayList<FileRotatedListener>();
        }
        this.fileRotatedListeners.add(listener);
    }

    @Override
    public void clearListeners() {
        if (this.fileRotatedListeners != null) {
            this.fileRotatedListeners.clear();
        }
    }

    @Override
    public Collection<FileRotatedListener> getListeners() {
        return Collections.unmodifiableCollection(this.fileRotatedListeners);
    }

    @Override
    public File getCurrentFile() {
        return this.currentFile;
    }

    @Override
    public ICompressedLocalAndRemoteOutputStream getDependentStream() {
        return this.dependentStream;
    }

    @Override
    public void setDependentStream(ICompressedLocalAndRemoteOutputStream dependentStream) {
        this.dependentStream = dependentStream;
    }

    @Override
    public Object getState() {
        return this.state;
    }

    @Override
    public void setState(Object state) {
        this.state = state;
    }

    static {
        try {
            GZIPOutputStream.class.getDeclaredConstructor(OutputStream.class, Integer.TYPE, Boolean.TYPE);
            isGZIPOutputStreamSyncFlushSupported = true;
        }
        catch (Throwable t) {
            isGZIPOutputStreamSyncFlushSupported = false;
        }
    }
}

