/*
 * Decompiled with CFR 0.152.
 */
package com.netcracker.profiler;

import com.netcracker.profiler.agent.PropertyFacadeBoot;
import com.netcracker.profiler.stream.ICompressedLocalAndRemoteOutputStream;
import com.netcracker.profiler.util.StringUtils;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GCDumper
implements Closeable {
    private static final Logger logger = LoggerFactory.getLogger(GCDumper.class);
    private static final String SHOULD_HARVEST_GC_LOG = PropertyFacadeBoot.getPropertyOrEnvVariable((String)"ESC_HARVEST_GCLOG");
    private static final Pattern[] GC_LOG_FILE_PATTERNS = new Pattern[]{Pattern.compile("-Xloggc:(.+)"), Pattern.compile("-Xlog.*:file=(..[^:]+)")};
    private static final Pattern[] NUM_GC_LOGS_PATTERNS = new Pattern[]{Pattern.compile("-XX:NumberOfGCLogFiles=([0-9]+)"), Pattern.compile("-Xlog.*:filecount=([0-9]+)")};
    private WatchService watcher;
    private ICompressedLocalAndRemoteOutputStream out;
    private FileInputStream gcInput;
    File gcFolderPath;
    File gcLogFile;
    long alreadyRead;
    int numGCLogFiles;
    String gcLogFileName;
    private boolean enabled = false;
    private boolean absentGCLogReported = false;
    private boolean isJava11 = false;

    private File getGcLogFile() {
        for (String arg : ManagementFactory.getRuntimeMXBean().getInputArguments()) {
            for (Pattern p : GC_LOG_FILE_PATTERNS) {
                File theFile;
                File theFolder;
                Matcher m = p.matcher(arg);
                if (!m.find() || !(theFolder = (theFile = new File(m.group(1)).getAbsoluteFile()).getParentFile()).exists() || !theFolder.isDirectory()) continue;
                logger.debug("Detected gc log file for export {}", (Object)theFile.getAbsolutePath());
                return theFile;
            }
        }
        logger.debug("No GC logs detected");
        return null;
    }

    private int getNumGCLogFiles() {
        for (String arg : ManagementFactory.getRuntimeMXBean().getInputArguments()) {
            for (Pattern p : NUM_GC_LOGS_PATTERNS) {
                String theNumber;
                Matcher m = p.matcher(arg);
                if (!m.find() || StringUtils.isBlank((CharSequence)(theNumber = m.group(1))) || !StringUtils.isNumeric((String)theNumber)) continue;
                logger.debug("detected number of GC log files {}", (Object)theNumber);
                return Integer.parseInt(theNumber);
            }
        }
        logger.debug("Can not detect number of GC log files. Asuming that GC is not rotated");
        return 0;
    }

    private void detectJavaVersion() {
        String javaVersion = System.getProperty("java.specification.version");
        if (StringUtils.isNumeric((String)javaVersion)) {
            this.isJava11 = Integer.parseInt(javaVersion) >= 11;
        }
        logger.trace("Is java 11: {}", (Object)this.isJava11);
    }

    public GCDumper(ICompressedLocalAndRemoteOutputStream out) {
        this.detectJavaVersion();
        if (!"true".equalsIgnoreCase(SHOULD_HARVEST_GC_LOG)) {
            return;
        }
        this.enabled = true;
        File gcLogFileBase = this.getGcLogFile();
        if (gcLogFileBase == null) {
            return;
        }
        this.gcFolderPath = gcLogFileBase.getParentFile();
        this.gcLogFileName = gcLogFileBase.getName();
        this.numGCLogFiles = this.getNumGCLogFiles();
        this.out = out;
        ArrayList<File> potentialCurrentLogs = new ArrayList<File>();
        for (File f : this.gcFolderPath.listFiles()) {
            if (!f.getName().startsWith(this.gcLogFileName) || !f.getName().endsWith(".current") && !f.getName().equals(this.gcLogFileName)) continue;
            potentialCurrentLogs.add(f);
        }
        Collections.sort(potentialCurrentLogs, new Comparator<File>(){

            @Override
            public int compare(File o1, File o2) {
                long delta = -(o1.lastModified() - o2.lastModified());
                return delta > 0L ? 1 : (delta == 0L ? 0 : -1);
            }
        });
        if (potentialCurrentLogs.size() > 0) {
            this.gcLogFile = (File)potentialCurrentLogs.get(0);
        }
        try {
            this.watcher = FileSystems.getDefault().newWatchService();
            Path gcLogPath = this.gcFolderPath.toPath();
            gcLogPath.register(this.watcher, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_MODIFY);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void reopenLog() throws IOException {
        block5: {
            try {
                this.closeGcInput();
            }
            catch (IOException e) {
                logger.warn("Failed to close previous gc log file ", (Throwable)e);
            }
            if (this.gcLogFile == null) {
                logger.info("Log file has not been detected in {} yet", (Object)this.gcFolderPath);
                return;
            }
            logger.trace("reopenning gc log file {}", (Object)this.gcLogFile.getAbsolutePath());
            try {
                this.gcInput = new FileInputStream(this.gcLogFile);
            }
            catch (FileNotFoundException e) {
                if (!this.gcLogFile.getName().endsWith(".current")) break block5;
                logger.trace("File {} not found. trying without .current extension", (Object)this.gcLogFile.getAbsolutePath());
                this.gcLogFile = new File(this.gcFolderPath, this.nameNoCurrent(this.gcLogFile));
                this.gcInput = new FileInputStream(this.gcLogFile);
            }
        }
        this.alreadyRead = 0L;
    }

    private List<File> collectModifiedFiles() {
        WatchKey wk;
        ArrayList<File> modifiedFiles = new ArrayList<File>();
        while ((wk = this.watcher.poll()) != null) {
            for (WatchEvent<?> we : wk.pollEvents()) {
                Path p = (Path)we.context();
                File newGCLog = p.toFile();
                if (logger.isTraceEnabled()) {
                    logger.trace("received event for file {}:{}", we.kind(), (Object)newGCLog.getAbsolutePath());
                }
                if (!newGCLog.getName().startsWith(this.gcLogFileName)) {
                    if (!logger.isTraceEnabled()) continue;
                    logger.trace("skipping modify event for {} since it does not match base gc log file name {}", (Object)newGCLog.getName(), (Object)this.gcLogFileName);
                    continue;
                }
                if (newGCLog.equals(this.gcLogFile)) continue;
                modifiedFiles.add(newGCLog);
            }
            wk.reset();
        }
        return modifiedFiles;
    }

    private TreeMap<Integer, String> mapGCLogIndexes(List<File> modifiedFiles) {
        TreeMap<Integer, String> indexesToNames = new TreeMap<Integer, String>();
        if (modifiedFiles.size() > 0) {
            HashSet<String> alreadyPresent = new HashSet<String>();
            for (File f : modifiedFiles) {
                String name = this.nameNoCurrent(f);
                if (alreadyPresent.contains(name)) continue;
                f = this.tryFindGCLog(name);
                if (f == null) {
                    logger.warn("failed to find gc log {}. file does not exist", (Object)name);
                    continue;
                }
                indexesToNames.put(this.indexFromName(name), name);
                alreadyPresent.add(name);
            }
        }
        return indexesToNames;
    }

    private List<String> retainOnlyThoseFollowingCurrentGCFile(TreeMap<Integer, String> indexesToNames) {
        ArrayList<String> namesToDump = new ArrayList<String>();
        if (this.gcLogFile == null) {
            namesToDump.addAll(indexesToNames.values());
        } else {
            int indexOfLog;
            int activeIndex = this.indexFromName(this.nameNoCurrent(this.gcLogFile));
            for (int i = 1; i < this.numGCLogFiles && indexesToNames.containsKey(indexOfLog = (i + activeIndex) % this.numGCLogFiles); ++i) {
                namesToDump.add(indexesToNames.get(indexOfLog));
            }
        }
        return namesToDump;
    }

    private boolean shouldReopenLog() throws IOException {
        List<File> modifiedFiles;
        TreeMap<Integer, String> indexesToNames;
        List<String> namesToDump;
        boolean result = false;
        if (!this.isJava11 && (namesToDump = this.retainOnlyThoseFollowingCurrentGCFile(indexesToNames = this.mapGCLogIndexes(modifiedFiles = this.collectModifiedFiles()))).size() > 0) {
            String lastFile = namesToDump.remove(namesToDump.size() - 1);
            for (String nameToDump : namesToDump) {
                logger.trace("intermediate GC log dumped {}", (Object)nameToDump);
                this.dumpFile(nameToDump);
            }
            result = true;
            this.gcLogFile = this.tryFindGCLog(lastFile);
            if (this.gcLogFile == null) {
                logger.trace("Failed to find an active GC log file by file name {}", (Object)lastFile);
                return false;
            }
            logger.trace("New gc log file to follow {}", (Object)this.gcLogFile.getAbsolutePath());
        }
        return result || this.gcInput == null || this.gcLogFile.length() < this.alreadyRead;
    }

    int indexFromName(String name) {
        int dotIndex = name.lastIndexOf(46);
        return Integer.parseInt(name.substring(dotIndex + 1));
    }

    String nameNoCurrent(File f) {
        String name = f.getName();
        if (name.endsWith(".current")) {
            name = name.substring(0, name.length() - ".current".length());
        }
        return name;
    }

    private void finishPreviousDump() throws IOException {
        if (this.gcInput != null) {
            this.readTillTheEnd();
            this.out.getStream().flush();
            this.out.rotate();
        }
    }

    private void dumpFile(String name) throws IOException {
        this.finishPreviousDump();
        this.gcLogFile = this.tryFindGCLog(name);
        if (this.gcLogFile == null) {
            logger.warn("Failed to find gc log file by name {}", (Object)name);
            return;
        }
        logger.trace("New log file to dump {}", (Object)this.gcLogFile.getAbsolutePath());
        this.reopenLog();
        this.readTillTheEnd();
        this.closeGcInput();
        this.gcLogFile = null;
    }

    private File tryFindGCLog(String name) {
        File f = new File(this.gcFolderPath, name);
        if (f.exists()) {
            return f;
        }
        f = new File(this.gcFolderPath, name + ".current");
        if (f.exists()) {
            return f;
        }
        return null;
    }

    public void dumpGC() throws IOException {
        if (!this.enabled) {
            return;
        }
        if (this.gcLogFile == null) {
            if (!this.absentGCLogReported) {
                logger.warn("gc log is absent. not dumping GC");
                this.absentGCLogReported = true;
            }
            return;
        }
        if (!this.gcLogFile.exists()) {
            logger.warn("File {} does not exist. can not export GC log", (Object)this.gcLogFile.getAbsolutePath());
            return;
        }
        if (this.gcInput != null) {
            this.readTillTheEnd();
        }
        if (this.shouldReopenLog()) {
            if (logger.isTraceEnabled()) {
                logger.trace("Reopenning GC log {}", (Object)this.gcLogFile.getAbsolutePath());
            }
            if (this.gcInput != null) {
                logger.trace("Rotating the stream");
                this.out.getStream().flush();
                this.out.rotate();
            }
            this.reopenLog();
        }
        if (this.gcInput != null) {
            this.readTillTheEnd();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readTillTheEnd() throws IOException {
        block6: {
            int len;
            byte[] buf = new byte[1024];
            while (true) {
                try {
                    len = this.gcInput.read(buf);
                }
                catch (IOException e) {
                    logger.error("Failed to read from gc log {}", (Object)this.gcFolderPath.getAbsolutePath(), (Object)e);
                    try {
                        this.closeGcInput();
                        break block6;
                    }
                    finally {
                        this.gcInput = null;
                    }
                }
                if (len <= 0) break;
                logger.trace("Sending {} bytes to gc log", (Object)len);
                this.alreadyRead += (long)len;
                this.out.getStream().write(buf, 0, len);
            }
            logger.trace("Read {} bytes from GC log", (Object)len);
        }
    }

    private void closeGcInput() throws IOException {
        if (this.gcInput != null) {
            this.gcInput.close();
        }
    }

    @Override
    public void close() throws IOException {
        logger.trace("closing GC dumper");
        try {
            this.closeGcInput();
        }
        finally {
            if (this.watcher != null) {
                this.watcher.close();
            }
        }
    }
}

