/*
 * Decompiled with CFR 0.152.
 */
package com.netcracker.profiler.metrics;

import com.netcracker.profiler.agent.Metric;
import com.netcracker.profiler.agent.MetricType;
import com.netcracker.profiler.metrics.AggregationParameter;
import com.netcracker.profiler.metrics.MetricUnit;
import com.netcracker.profiler.util.StringUtils;
import java.util.HashSet;

public abstract class AbstractMetric
implements Metric {
    protected String key;
    protected int outputVersion;
    private volatile long updatedTime;

    public AbstractMetric(String callType, MetricType type, HashSet<AggregationParameter> aggregationParameters, MetricUnit metricUnit, int outputVersion, String suffix) {
        this.outputVersion = outputVersion;
        this.key = this.buildKey(callType, type, aggregationParameters, metricUnit, suffix);
    }

    public AbstractMetric(String callType, MetricType type, HashSet<AggregationParameter> aggregationParameters, MetricUnit metricUnit, int outputVersion) {
        this(callType, type, aggregationParameters, metricUnit, outputVersion, null);
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public int getOutputVersion() {
        return this.outputVersion;
    }

    public void setOutputVersion(int outputVersion) {
        this.outputVersion = outputVersion;
    }

    public long getUpdatedTime() {
        return this.updatedTime;
    }

    public void resetUpdatedTime() {
        this.updatedTime = System.currentTimeMillis();
    }

    protected String buildKey(String callType, MetricType type, HashSet<AggregationParameter> aggregationParameters, MetricUnit metricUnit, String suffix) {
        if (this.outputVersion == 1) {
            return this.buildLegacyKey(callType, type, aggregationParameters, suffix);
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(callType).append("_").append(type.getOutputName()).append("_").append(metricUnit.getOutputValue());
        if (!StringUtils.isEmpty((CharSequence)suffix)) {
            stringBuilder.append("_").append(suffix);
        }
        stringBuilder.append("{");
        if (!aggregationParameters.isEmpty()) {
            for (AggregationParameter aggregationParameter : aggregationParameters) {
                stringBuilder.append(aggregationParameter.toString()).append(", ");
            }
            stringBuilder.delete(stringBuilder.length() - 2, stringBuilder.length());
        }
        return stringBuilder.toString();
    }

    protected String buildKey(String callType, MetricType type, HashSet<AggregationParameter> aggregationParameters, MetricUnit metricUnit) {
        return this.buildKey(callType, type, aggregationParameters, metricUnit, null);
    }

    private String buildLegacyKey(String callType, MetricType type, HashSet<AggregationParameter> aggregationParameters, String suffix) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("esc_").append(type.getOutputName()).append("s");
        if (!StringUtils.isEmpty((CharSequence)suffix)) {
            stringBuilder.append("_").append(suffix);
        }
        stringBuilder.append("{type=\"").append(callType).append("\"");
        for (AggregationParameter aggregationParameter : aggregationParameters) {
            stringBuilder.append(", ").append(aggregationParameter.toString());
        }
        return stringBuilder.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractMetric that = (AbstractMetric)o;
        if (this.updatedTime != that.updatedTime) {
            return false;
        }
        return this.key.equals(that.key);
    }

    public int hashCode() {
        int result = this.key.hashCode();
        result = 31 * result + (int)(this.updatedTime ^ this.updatedTime >>> 32);
        return result;
    }
}

