/*
 * Decompiled with CFR 0.152.
 */
package com.netcracker.profiler.metrics;

import com.netcracker.profiler.agent.CallInfo;
import com.netcracker.profiler.agent.MetricType;
import com.netcracker.profiler.dump.ThreadState;
import com.netcracker.profiler.metrics.AbstractHistogramMetric;
import com.netcracker.profiler.metrics.AggregationParameter;
import com.netcracker.profiler.metrics.MetricUnit;
import java.util.HashSet;
import java.util.Map;

public class DiskIOMetric
extends AbstractHistogramMetric {
    private final long DEFAULT_VALUE_UNITS_IN_FIRST_BUCKET = 8L;
    private final long DEFAULT_LOWEST_DISCERNIBLE_VALUE = 8L;
    private final long DEFAULT_HIGHEST_TRACKABLE_VALUE = 100000000L;
    private static final MetricType METRIC_TYPE = MetricType.DISK_IO;
    private static final MetricUnit METRIC_UNIT = MetricUnit.KILOBYTES;

    public DiskIOMetric(String callType, HashSet<AggregationParameter> aggregationParameters, Map<String, String> metricParameters, int outputVersion) {
        super(callType, METRIC_TYPE, aggregationParameters, METRIC_UNIT, outputVersion, "bucket");
        this.valueUnitsInFirstBucket = 8L;
        this.lowestDiscernibleValue = 8L;
        this.highestTrackableValue = 100000000L;
        this.parseHistogramParameters(metricParameters);
        this.initHistogram();
    }

    public void recordValue(long value, Map<String, Object> params) {
        CallInfo callInfo = (CallInfo)params.get("callInfo");
        ThreadState threadState = (ThreadState)params.get("threadState");
        long fileRead = callInfo.fileRead - threadState.prevFileRead;
        long fileWritten = callInfo.fileWritten - threadState.prevFileWritten;
        this.recordValue((fileRead + fileWritten) / 1024L);
    }
}

