/*
 * Decompiled with CFR 0.152.
 */
package com.netcracker.profiler.metrics;

import com.netcracker.profiler.agent.Bootstrap;
import com.netcracker.profiler.agent.Metric;
import com.netcracker.profiler.agent.MetricType;
import com.netcracker.profiler.agent.MetricsConfiguration;
import com.netcracker.profiler.agent.MetricsDescription;
import com.netcracker.profiler.agent.MetricsPlugin;
import com.netcracker.profiler.agent.Profiler;
import com.netcracker.profiler.agent.SystemMetric;
import com.netcracker.profiler.metrics.AggregationParameter;
import com.netcracker.profiler.metrics.CPUMetric;
import com.netcracker.profiler.metrics.CountMetric;
import com.netcracker.profiler.metrics.DirtyBuffersMetric;
import com.netcracker.profiler.metrics.DiskIOMetric;
import com.netcracker.profiler.metrics.DurationMetric;
import com.netcracker.profiler.metrics.EmptyBuffersMetric;
import com.netcracker.profiler.metrics.MemoryMetric;
import com.netcracker.profiler.metrics.MetricsKey;
import com.netcracker.profiler.metrics.NetworkIOMetric;
import com.netcracker.profiler.metrics.QueueWaitTimeMetric;
import com.netcracker.profiler.metrics.TransactionMetric;
import com.netcracker.profiler.util.StringUtils;
import gnu.trove.set.hash.THashSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricsPluginImpl
implements MetricsPlugin {
    private static final int INTERVAL_TO_SHOW_METRIC = 3600000;
    private static final Logger LOG = LoggerFactory.getLogger(MetricsPluginImpl.class);
    private ConcurrentHashMap<MetricsKey, Metric> callMetrics = new ConcurrentHashMap();
    private HashSet<SystemMetric> systemMetrics = new HashSet();

    public MetricsPluginImpl() {
        Bootstrap.registerPlugin(MetricsPlugin.class, (Object)this);
    }

    public Metric getMetric(MetricType metricType, String callType, Map<String, String> aggregationParameters) {
        HashSet<AggregationParameter> aggregationParameterHashSet = new HashSet<AggregationParameter>();
        for (Map.Entry<String, String> aggregationParameter : aggregationParameters.entrySet()) {
            THashSet aggregationParamValues = new THashSet();
            aggregationParamValues.add((Object)aggregationParameter.getValue());
            aggregationParameterHashSet.add(new AggregationParameter(aggregationParameter.getKey(), (THashSet<String>)aggregationParamValues));
        }
        MetricsConfiguration metricsConfiguration = Profiler.getMetricConfigByName((String)callType);
        if (metricsConfiguration == null) {
            LOG.error("MetricsConfiguration not found for callType: {}", (Object)callType);
            return null;
        }
        for (MetricsDescription metricsDescription : metricsConfiguration.getMetrics()) {
            if (!metricType.getConfigName().equals(metricsDescription.getName())) continue;
            return this.getOrCreateMetric(metricType, callType, aggregationParameterHashSet, metricsConfiguration.isCustom(), metricsDescription.getParameters(), metricsConfiguration.getOutputVersion());
        }
        LOG.error("MetricsDescription not found for metricType: {}", (Object)metricType);
        return null;
    }

    public Metric getOrCreateMetric(MetricType metricType, String callType, HashSet<AggregationParameter> aggregationParameters, boolean isCustom, Map<String, String> metricParameters, int outputVersion) {
        MetricsKey key = new MetricsKey(callType, metricType, aggregationParameters, isCustom);
        Metric metric = this.callMetrics.get(key);
        if (metric == null) {
            metric = this.createMetric(metricType, callType, aggregationParameters, metricParameters, outputVersion);
            metric.resetUpdatedTime();
            this.callMetrics.put(key, metric);
        }
        return metric;
    }

    public String getMetrics() {
        StringBuilder result = new StringBuilder();
        ConcurrentHashMap<MetricsKey, Metric> metricsToDelete = new ConcurrentHashMap<MetricsKey, Metric>();
        for (Map.Entry<MetricsKey, Metric> entry : this.callMetrics.entrySet()) {
            if (entry.getKey().isCustom()) continue;
            if (System.currentTimeMillis() - entry.getValue().getUpdatedTime() <= 3600000L) {
                entry.getValue().print(result);
                continue;
            }
            metricsToDelete.put(entry.getKey(), entry.getValue());
        }
        for (MetricsKey metricsKey : metricsToDelete.keySet()) {
            this.callMetrics.remove(metricsKey);
        }
        for (SystemMetric systemMetric : this.systemMetrics) {
            systemMetric.print(result);
        }
        return result.toString();
    }

    public void resetMetrics() {
        this.callMetrics.clear();
        this.systemMetrics.clear();
    }

    private Metric createMetric(MetricType metricType, String callType, HashSet<AggregationParameter> aggregationParameters, Map<String, String> metricParameters, int outputVersion) {
        switch (metricType) {
            case COUNT: {
                return new CountMetric(callType, aggregationParameters, outputVersion);
            }
            case DURATION: {
                return new DurationMetric(callType, aggregationParameters, metricParameters, outputVersion);
            }
            case CPU: {
                return new CPUMetric(callType, aggregationParameters, metricParameters, outputVersion);
            }
            case QUEUE_WAIT_TIME: {
                return new QueueWaitTimeMetric(callType, aggregationParameters, metricParameters, outputVersion);
            }
            case TRANSACTIONS: {
                return new TransactionMetric(callType, aggregationParameters, metricParameters, outputVersion);
            }
            case DISK_IO: {
                return new DiskIOMetric(callType, aggregationParameters, metricParameters, outputVersion);
            }
            case NETWORK_IO: {
                return new NetworkIOMetric(callType, aggregationParameters, metricParameters, outputVersion);
            }
            case MEMORY: {
                return new MemoryMetric(callType, aggregationParameters, metricParameters, outputVersion);
            }
        }
        throw new RuntimeException("Incorrect metric name");
    }

    public void createSystemMetrics(List<MetricsDescription> metricsDescriptions) {
        block4: for (MetricsDescription md : metricsDescriptions) {
            MetricType metricType = MetricType.getByConfigName((String)md.getName());
            if (metricType == null) {
                throw new RuntimeException("Incorrect metric name");
            }
            String metricName = (String)md.getParameters().get("name");
            metricName = StringUtils.isEmpty((CharSequence)metricName) ? md.getName() : metricName;
            switch (metricType) {
                case PROFILER_DIRTY_BUFFERS: {
                    this.systemMetrics.add(new DirtyBuffersMetric(metricName));
                    continue block4;
                }
                case PROFILER_EMPTY_BUFFERS: {
                    this.systemMetrics.add(new EmptyBuffersMetric(metricName));
                    continue block4;
                }
            }
            throw new RuntimeException("Incorrect metric name");
        }
    }
}

