/*
 * Decompiled with CFR 0.152.
 */
package com.netcracker.profiler.metrics;

import com.netcracker.profiler.agent.CallInfo;
import com.netcracker.profiler.agent.MetricType;
import com.netcracker.profiler.dump.ThreadState;
import com.netcracker.profiler.metrics.AbstractHistogramMetric;
import com.netcracker.profiler.metrics.AggregationParameter;
import com.netcracker.profiler.metrics.MetricUnit;
import java.util.HashSet;
import java.util.Map;

public class NetworkIOMetric
extends AbstractHistogramMetric {
    private final long DEFAULT_VALUE_UNITS_IN_FIRST_BUCKET = 16L;
    private final long DEFAULT_LOWEST_DISCERNIBLE_VALUE = 16L;
    private final long DEFAULT_HIGHEST_TRACKABLE_VALUE = 100000000L;
    private static final MetricType METRIC_TYPE = MetricType.NETWORK_IO;
    private static final MetricUnit METRIC_UNIT = MetricUnit.KILOBYTES;

    public NetworkIOMetric(String callType, HashSet<AggregationParameter> aggregationParameters, Map<String, String> metricParameters, int outputVersion) {
        super(callType, METRIC_TYPE, aggregationParameters, METRIC_UNIT, outputVersion, "bucket");
        this.valueUnitsInFirstBucket = 16L;
        this.lowestDiscernibleValue = 16L;
        this.highestTrackableValue = 100000000L;
        this.parseHistogramParameters(metricParameters);
        this.initHistogram();
    }

    public void recordValue(long value, Map<String, Object> params) {
        CallInfo callInfo = (CallInfo)params.get("callInfo");
        ThreadState threadState = (ThreadState)params.get("threadState");
        long netRead = callInfo.netRead - threadState.prevNetRead;
        long netWritten = callInfo.netWritten - threadState.prevNetWritten;
        this.recordValue((netRead + netWritten) / 1024L);
    }
}

