/*
 * Decompiled with CFR 0.152.
 */
package com.netcracker.profiler.transfer;

import com.netcracker.profiler.agent.NetworkExportParams;
import com.netcracker.profiler.agent.ProfilerData;
import com.netcracker.profiler.agent.TimerCache;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.util.ArrayList;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSender
extends Thread {
    private static final Logger log = LoggerFactory.getLogger(DataSender.class);
    private ArrayBlockingQueue<ByteArrayOutputStream> jsonsToSend;
    private ArrayBlockingQueue<ByteArrayOutputStream> emptyJsonBuffers;
    private Socket socket;
    private BufferedOutputStream out;
    private String host;
    private int port;
    private int socketTimeout;
    int sleepInterval = 1000;
    long timestamp1 = TimerCache.now;
    private volatile boolean reconfigureRequired;
    private Lock configurationLock = new ReentrantLock();
    private volatile boolean shutdownRequested;
    private boolean forceShutdown;
    final Thread SHUTDOWN_HOOK = new Thread(){

        @Override
        public void run() {
            DataSender.this.shutdown();
        }
    };

    public void initalizeConnection() {
        while (true) {
            try {
                this.closeConnection();
                if (this.forceShutdown) {
                    return;
                }
                this.configurationLock.lock();
                try {
                    this.socket = new Socket(this.host, this.port);
                    this.socket.setSoTimeout(this.socketTimeout);
                }
                finally {
                    this.configurationLock.unlock();
                }
                this.out = new BufferedOutputStream(this.socket.getOutputStream());
                log.info("Socket connection initalized");
                this.reconfigureRequired = false;
                return;
            }
            catch (IOException e) {
                if (this.shutdownRequested) {
                    this.forceShutdown = true;
                }
                try {
                    Thread.sleep(this.sleepInterval);
                    if (this.sleepInterval < 60000) {
                        this.sleepInterval *= 2;
                    }
                }
                catch (InterruptedException e1) {
                    log.error("Thread interrupted", (Throwable)e1);
                }
                log.error("Can not initalize socket connection: host {}, port {}. Check the server(logstash) and fields call-export->network->host/port in profiler config", (Object)this.host, (Object)this.port);
                continue;
            }
            break;
        }
    }

    public DataSender(NetworkExportParams params) {
        this.configure(params);
        this.jsonsToSend = new ArrayBlockingQueue(ProfilerData.DATA_SENDER_QUEUE_SIZE);
        this.emptyJsonBuffers = new ArrayBlockingQueue(ProfilerData.DATA_SENDER_QUEUE_SIZE);
        for (int i = 0; i < ProfilerData.DATA_SENDER_QUEUE_SIZE; ++i) {
            this.emptyJsonBuffers.add(new ByteArrayOutputStream());
        }
        this.setDaemon(true);
    }

    public void configure(NetworkExportParams params) {
        this.configurationLock.lock();
        try {
            if (this.configurationChanged(params)) {
                this.host = params.getHost();
                this.port = params.getPort();
                this.socketTimeout = params.getSocketTimeout();
                this.reconfigureRequired = true;
            }
        }
        finally {
            this.configurationLock.unlock();
        }
    }

    private boolean configurationChanged(NetworkExportParams params) {
        if (this.host == null) {
            return true;
        }
        if (!this.host.equals(params.getHost())) {
            return true;
        }
        if (this.port != params.getPort()) {
            return true;
        }
        return this.socketTimeout != params.getSocketTimeout();
    }

    public void shutdown() {
        this.shutdownRequested = true;
    }

    public ArrayBlockingQueue<ByteArrayOutputStream> getJsonsToSend() {
        return this.jsonsToSend;
    }

    public ArrayBlockingQueue<ByteArrayOutputStream> getEmptyJsonBuffers() {
        return this.emptyJsonBuffers;
    }

    @Override
    public void run() {
        Runtime.getRuntime().addShutdownHook(this.SHUTDOWN_HOOK);
        while (!this.shutdownRequested) {
            try {
                this.senderLoop();
            }
            catch (Throwable e) {
                log.error("Error in DataSender loop: ", e);
                try {
                    Thread.sleep(this.sleepInterval);
                    if (this.sleepInterval < 60000) {
                        this.sleepInterval *= 2;
                    }
                    this.initalizeConnection();
                }
                catch (InterruptedException e1) {
                    log.error("Thread interrupted", (Throwable)e1);
                }
            }
        }
        try {
            Runtime.getRuntime().removeShutdownHook(this.SHUTDOWN_HOOK);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    private void senderLoop() {
        ArrayList<ByteArrayOutputStream> streams = new ArrayList<ByteArrayOutputStream>(100);
        while (true) {
            if (this.shutdownRequested && this.jsonsToSend.isEmpty() || this.forceShutdown) {
                this.closeConnection();
                return;
            }
            if (this.reconfigureRequired) {
                this.initalizeConnection();
            }
            if (this.jsonsToSend.drainTo(streams, 100) == 0) {
                try {
                    ByteArrayOutputStream firstBaos = this.jsonsToSend.poll(1L, TimeUnit.SECONDS);
                    if (firstBaos != null) {
                        streams.add(firstBaos);
                    }
                }
                catch (InterruptedException e) {
                    log.error("Reading from  ArrayBlockingQueue interrupted ", (Throwable)e);
                }
            }
            for (ByteArrayOutputStream baos : streams) {
                if (baos.size() > 2) {
                    this.sendData(baos);
                }
                baos.reset();
                this.emptyJsonBuffers.add(baos);
            }
            streams.clear();
            this.flushIfRequired();
            this.sleepInterval = 1000;
        }
    }

    private void sendData(ByteArrayOutputStream forSend) {
        try {
            forSend.writeTo(this.out);
            this.out.write(10);
        }
        catch (IOException e) {
            log.warn("Connection lost. Trying restart socket connection.", (Throwable)e);
            this.initalizeConnection();
        }
    }

    private void flushIfRequired() {
        long timestamp2 = TimerCache.now;
        if (timestamp2 - this.timestamp1 > 5000L) {
            try {
                this.out.flush();
            }
            catch (IOException e) {
                log.warn("Connection lost. Trying restart socket connection.", (Throwable)e);
                this.initalizeConnection();
            }
            this.timestamp1 = timestamp2;
        }
    }

    private void closeConnection() {
        try {
            if (this.out != null) {
                this.out.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.socket != null) {
                this.socket.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

