/*
 * Decompiled with CFR 0.152.
 */
package com.netcracker.profiler.util;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.netcracker.profiler.ServerNameResolver;
import com.netcracker.profiler.agent.CallInfo;
import com.netcracker.profiler.agent.FilterOperator;
import com.netcracker.profiler.agent.NetworkExportParams;
import com.netcracker.profiler.agent.ProfilerData;
import com.netcracker.profiler.agent.TimerCache;
import com.netcracker.profiler.dump.ThreadState;
import com.netcracker.profiler.formatters.title.ProfilerTitle;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.procedure.TIntObjectProcedure;
import gnu.trove.set.hash.THashSet;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DumperCallsExporter {
    private static final Logger log = LoggerFactory.getLogger(DumperCallsExporter.class);
    private static final String PROFILER_BASE_URL = "/profiler/tree.html#params-trim-size=15000&";
    private static Map<String, Object> params = new HashMap<String, Object>(4);
    private static Map<String, String> additionalInputParams = new HashMap<String, String>(2);
    private ArrayBlockingQueue<ByteArrayOutputStream> jsonsToSend;
    private ArrayBlockingQueue<ByteArrayOutputStream> emptyJsonBuffers;
    private List<String> includedParams;
    private List<String> excludedParams;
    private FilterOperator callFilter;
    private JsonFactory jsonFactory = new JsonFactory();
    private long missed = 0L;
    private long prevMissed = 0L;
    private long t1 = TimerCache.now;
    private long t2;
    private JsonGenerator jgen = null;
    private HashMap<String, String> callParams = new HashMap();
    private HashSet<String> allowedParams = new HashSet();
    List<String> dictionary = ProfilerData.getTags();
    final TIntObjectProcedure<THashSet<String>> WRITE_PARAMS_JSON = new TIntObjectProcedure<THashSet<String>>(){

        public boolean execute(int id, THashSet<String> set) {
            try {
                String paramName = DumperCallsExporter.this.dictionary.get(id);
                if ((DumperCallsExporter.this.includedParams.contains(paramName) || DumperCallsExporter.this.includedParams.isEmpty() && !DumperCallsExporter.this.excludedParams.contains(paramName)) && !set.isEmpty() && id < DumperCallsExporter.this.dictionary.size() && id > -1) {
                    if (set.size() == 1) {
                        DumperCallsExporter.this.jgen.writeObjectField(paramName, set.toArray()[0]);
                    } else if (set.size() > 1) {
                        DumperCallsExporter.this.jgen.writeFieldName(paramName);
                        DumperCallsExporter.this.jgen.writeStartArray();
                        for (String s : set) {
                            DumperCallsExporter.this.jgen.writeObject((Object)s);
                        }
                        DumperCallsExporter.this.jgen.writeEndArray();
                    }
                }
            }
            catch (IOException e) {
                log.error("Error during writing into JSON", (Throwable)e);
            }
            return true;
        }
    };

    public synchronized void configureExport(ArrayBlockingQueue<ByteArrayOutputStream> jsonsToSend, ArrayBlockingQueue<ByteArrayOutputStream> emptyJsonBuffers, NetworkExportParams exportParams) {
        this.callParams.clear();
        this.jsonsToSend = jsonsToSend;
        this.emptyJsonBuffers = emptyJsonBuffers;
        if (exportParams == null) {
            this.includedParams = Collections.EMPTY_LIST;
            this.excludedParams = Collections.EMPTY_LIST;
            this.callFilter = null;
        }
        this.includedParams = exportParams.getIncludedParams() == null ? Collections.EMPTY_LIST : exportParams.getIncludedParams();
        this.excludedParams = exportParams.getExcludedParams() == null ? Collections.EMPTY_LIST : exportParams.getExcludedParams();
        this.callFilter = exportParams.getFilter();
        this.allowedParams.clear();
        if (this.includedParams.isEmpty()) {
            this.allowedParams.add("start.timestamp");
            this.allowedParams.add("profiler.title");
            this.allowedParams.add("node.name");
            this.allowedParams.add("java.thread");
            this.allowedParams.add("duration");
            this.allowedParams.add("time.suspension");
            this.allowedParams.add("time.queue.wait");
            this.allowedParams.add("time.concurrent.wait");
            this.allowedParams.add("time.cpu");
            this.allowedParams.add("method.name");
            this.allowedParams.add("log.generated");
            this.allowedParams.add("log.written");
            this.allowedParams.add("memory.allocated");
            this.allowedParams.add("io.disk.read");
            this.allowedParams.add("io.disk.written");
            this.allowedParams.add("io.net.read");
            this.allowedParams.add("io.net.written");
            this.allowedParams.add("j2ee.transactions");
            this.allowedParams.add("calls");
            this.allowedParams.add("profiler.url");
            this.allowedParams.removeAll(this.excludedParams);
        } else {
            this.allowedParams.addAll(this.includedParams);
        }
        for (String property : exportParams.getSystemProperties()) {
            this.callParams.put(property, System.getProperty(property));
            this.allowedParams.add(property);
        }
    }

    private ByteArrayOutputStream buildJson(long startTimestamp, long callDuration, long callSuspension, CallInfo callInfo, ProfilerTitle profilerTitle, ThreadState thread, String threadName, String dumpDir, ByteArrayOutputStream outputStream) throws IOException {
        this.jgen = this.jsonFactory.createGenerator((OutputStream)outputStream);
        TIntObjectHashMap params = thread.params;
        this.callParams.put("start.timestamp", String.valueOf(startTimestamp));
        this.callParams.put("profiler.title", String.valueOf(profilerTitle.getText()));
        this.callParams.put("node.name", String.valueOf(ServerNameResolver.SERVER_NAME));
        this.callParams.put("java.thread", String.valueOf(threadName));
        this.callParams.put("duration", String.valueOf(callDuration));
        this.callParams.put("time.suspension", String.valueOf(callSuspension));
        this.callParams.put("time.queue.wait", String.valueOf(callInfo.queueWaitDuration));
        this.callParams.put("time.concurrent.wait", String.valueOf(callInfo.waitTime - thread.prevWaitTime));
        this.callParams.put("time.cpu", String.valueOf(callInfo.cpuTime - thread.prevCpuTime));
        this.callParams.put("method.name", this.dictionary.get(thread.method));
        this.callParams.put("log.generated", String.valueOf(callInfo.logGenerated));
        this.callParams.put("log.written", String.valueOf(callInfo.logWritten));
        this.callParams.put("memory.allocated", String.valueOf(callInfo.memoryUsed - thread.prevMemoryUsed));
        this.callParams.put("io.disk.read", String.valueOf(callInfo.fileRead - thread.prevFileRead));
        this.callParams.put("io.disk.written", String.valueOf(callInfo.fileWritten - thread.prevFileWritten));
        this.callParams.put("io.net.read", String.valueOf(callInfo.netRead - thread.prevNetRead));
        this.callParams.put("io.net.written", String.valueOf(callInfo.netWritten - thread.prevNetWritten));
        this.callParams.put("j2ee.transactions", String.valueOf(callInfo.transactions - thread.prevTransactions));
        this.callParams.put("calls", String.valueOf(thread.calls));
        this.callParams.put("profiler.url", this.buildProfilerUrl(dumpDir, thread));
        this.jgen.writeStartObject();
        for (Map.Entry<String, String> entry : this.callParams.entrySet()) {
            if (!this.allowedParams.contains(entry.getKey())) continue;
            this.jgen.writeStringField(entry.getKey(), entry.getValue());
        }
        params.forEachEntry(this.WRITE_PARAMS_JSON);
        this.jgen.writeEndObject();
        if (this.jgen != null) {
            this.jgen.close();
        }
        return outputStream;
    }

    private String buildProfilerUrl(String dumpDir, ThreadState threadState) {
        String rowid = "0_" + threadState.traceFileIndex + "_" + threadState.bufferOffset + "_" + threadState.recordIndex + "_" + 0 + "_" + 0;
        return "/profiler/tree.html#params-trim-size=15000&f[_0]=" + dumpDir + "&i=" + rowid;
    }

    public synchronized void exportCall(long startTimestamp, long callDuration, long callSuspension, CallInfo callInfo, ProfilerTitle profilerTitle, ThreadState threadState, String threadName, String dumpDir) {
        try {
            if (this.isEnabled()) {
                if (!this.filterCall(callDuration, callInfo, threadName, threadState)) {
                    return;
                }
                ByteArrayOutputStream baos = this.emptyJsonBuffers.poll();
                if (baos != null) {
                    ByteArrayOutputStream baosForSend = this.buildJson(startTimestamp, callDuration, callSuspension, callInfo, profilerTitle, threadState, threadName, dumpDir, baos);
                    this.jsonsToSend.add(baosForSend);
                } else {
                    ++this.missed;
                    this.t2 = TimerCache.now;
                }
                if (this.missed != this.prevMissed && this.t2 - this.t1 > 60000L) {
                    log.warn("{} jsons missed since startup", (Object)this.missed);
                    this.prevMissed = this.missed;
                    this.t1 = this.t2;
                }
            }
        }
        catch (Exception ex) {
            log.error("Error in exportCall: ", (Throwable)ex);
        }
    }

    public boolean isEnabled() {
        return this.jsonsToSend != null && this.emptyJsonBuffers != null;
    }

    private boolean filterCall(long callDuration, CallInfo callInfo, String threadName, ThreadState threadState) {
        if (this.callFilter == null) {
            return true;
        }
        params.put("callInfo", callInfo);
        params.put("threadState", threadState);
        params.put("duration", callDuration);
        additionalInputParams.put("java.thread", threadName);
        return this.callFilter.evaluate(params);
    }

    static {
        additionalInputParams.put("node.name", String.valueOf(ServerNameResolver.SERVER_NAME));
        params.put("additionalInputParams", additionalInputParams);
    }
}

