/*
 * Decompiled with CFR 0.152.
 */
package com.netcracker.profiler.util.cache;

import gnu.trove.map.hash.TLongIntHashMap;

public class TLimitedLongIntHashMap
extends TLongIntHashMap {
    final int maxSize;
    final int IS_FREQUENT = Integer.MIN_VALUE;
    int clock = 0;

    public TLimitedLongIntHashMap() {
        this(1000);
    }

    public TLimitedLongIntHashMap(int maxSize) {
        this.maxSize = maxSize;
        this.setAutoCompactionFactor(0.0f);
    }

    public int get(long key) {
        int index = this.index(key);
        if (index < 0) {
            return -1;
        }
        int value = this._values[index];
        this._values[index] = value | Integer.MIN_VALUE;
        return value & Integer.MAX_VALUE;
    }

    public int put(long key, int value) {
        if (this.size() >= this.maxSize) {
            this.evictStale(Math.max((int)((float)this.maxSize * 0.15f), 1));
        }
        return super.put(key, value);
    }

    private void evictStale(int killsLeft) {
        int[] values = this._values;
        byte[] states = this._states;
        long[] set = this._set;
        int length = set.length;
        int clock = this.clock;
        while (killsLeft > 0) {
            if (states[clock] == 1) {
                int val = values[clock];
                if ((val & Integer.MIN_VALUE) != 0) {
                    values[clock] = val & Integer.MAX_VALUE;
                } else {
                    this.removeAt(clock);
                    --killsLeft;
                }
            }
            if (++clock != length) continue;
            clock = 0;
        }
        this.clock = clock;
    }
}

