/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tools.ant.Location;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Target;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Property;
import org.qubership.profiler.agent.JSHelper;
import org.qubership.profiler.agent.Profiler;

public class Ant
extends Task {
    private String antFile;
    private Vector targets;
    private Vector<Property> properties = new Vector();

    private void logEntry$profiler() {
        try {
            Target target;
            String method;
            switch (this.targets.size()) {
                case 0: {
                    method = "default";
                    break;
                }
                case 1: {
                    method = this.targets.get(0).toString();
                    break;
                }
                default: {
                    StringBuilder sbStr = new StringBuilder();
                    int il = this.targets.size();
                    for (int i = 0; i < il; ++i) {
                        if (i > 0) {
                            sbStr.append("___");
                        }
                        sbStr.append(this.targets.get(i));
                    }
                    method = sbStr.toString();
                }
            }
            Project project = this.getProject();
            String currentFile = project.getProperty("ant.file");
            Location location = null;
            String targetFile = null;
            if (currentFile != null && currentFile.equals(this.antFile) && (target = project.getTargets().get(method)) != null && (location = target.getLocation()) != null) {
                targetFile = location.getFileName();
            }
            if (location == null) {
                location = this.getLocation();
                targetFile = this.antFile;
            }
            if (targetFile == null || targetFile.length() == 0) {
                targetFile = "unknown";
            }
            if (targetFile.endsWith(".xml")) {
                targetFile = targetFile.substring(0, targetFile.length() - 4);
            }
            if (targetFile.startsWith("/")) {
                targetFile = targetFile.substring(1);
            }
            targetFile = targetFile.replace('.', '_').replace('/', '.');
            String locationString = Ant.locationToString$profiler(location);
            method = method.replace('.', '_');
            Profiler.enter((String)("void " + targetFile + "." + method + "() (" + locationString + ") [unknown jar]"));
            if (this.properties.size() == 0) {
                return;
            }
            if (this.properties.size() == 1 && "install.step".equals(this.properties.get(0).getName()) && method.startsWith("step")) {
                return;
            }
            StringWriter sw = new StringWriter();
            sw.append('{');
            boolean needComma = false;
            Pattern pass = Pattern.compile("pass", 2);
            Matcher passFinder = pass.matcher("");
            for (Property p : this.properties) {
                try {
                    if (needComma) {
                        sw.append(',');
                    }
                    needComma = true;
                    sw.append('\"');
                    JSHelper.escapeJS((Writer)sw, (String)p.getName());
                    sw.append("\":\"");
                    passFinder.reset(p.getName());
                    if (passFinder.find()) {
                        sw.append("***");
                    } else {
                        JSHelper.escapeJS((Writer)sw, (String)p.getValue());
                    }
                    sw.append('\"');
                    if (!"install_zip".equals(method) || !"zip_name".equals(p.getName())) continue;
                    Profiler.event((Object)p.getValue(), (String)"ai.zip");
                    return;
                }
                catch (IOException iOException) {
                }
            }
            sw.append('}');
            Profiler.event((Object)sw.toString(), (String)"antcall.json");
        }
        catch (Throwable t) {
            Profiler.enter((String)"void null.null() (null) [unknown jar]");
            throw t;
        }
    }

    public static String locationToString$profiler(Location location) {
        String result;
        String string = result = location == null ? null : location.toString();
        if (result == null || result.length() == 0) {
            result = "Ant.java:0";
        } else if (result.length() > 5) {
            result = result.substring(0, result.length() - 2);
        }
        return result;
    }

    private void logExit$profiler(Throwable t) {
        this.logExit$profiler();
    }

    private void logExit$profiler() {
        Profiler.exit();
    }
}

