/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.agent.http;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.qubership.profiler.agent.ESCLogger;
import org.qubership.profiler.agent.http.HttpServletRequestAdapter;

public class ServletRequestAdapter {
    private static final ESCLogger logger = ESCLogger.getLogger(ServletRequestAdapter.class);
    private Object servletRequest;
    private Class javaxHttpServletRequestClass;
    private Class jakartaHttpServletRequestClass;
    private Method getRemoteAddr;
    private Method getRemoteHost;
    private Method setAttribute;

    public ServletRequestAdapter(Object servletRequest) throws ClassNotFoundException, NoSuchMethodException {
        this.servletRequest = servletRequest;
        try {
            this.javaxHttpServletRequestClass = Class.forName("javax.servlet.http.HttpServletRequest", false, servletRequest.getClass().getClassLoader());
        }
        catch (ClassNotFoundException e) {
            logger.fine("Package javax.servlet doesn't available. It seems that will use Jakarta EE.");
        }
        try {
            this.jakartaHttpServletRequestClass = Class.forName("jakarta.servlet.http.HttpServletRequest", false, servletRequest.getClass().getClassLoader());
        }
        catch (ClassNotFoundException e) {
            logger.fine("Package jakarta.servlet doesn't available. It seems that will use Java EE.");
        }
        try {
            this.getRemoteAddr = servletRequest.getClass().getMethod("getRemoteAddr", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            logger.severe("", e);
        }
        try {
            this.getRemoteHost = servletRequest.getClass().getMethod("getRemoteHost", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            logger.severe("", e);
        }
        try {
            this.setAttribute = servletRequest.getClass().getMethod("setAttribute", String.class, Object.class);
        }
        catch (NoSuchMethodException e) {
            logger.severe("", e);
        }
    }

    public HttpServletRequestAdapter toHttpServletRequestAdapter() throws NoSuchMethodException {
        return new HttpServletRequestAdapter(this.servletRequest);
    }

    public boolean isHttpServetRequest() {
        if (this.javaxHttpServletRequestClass != null) {
            return this.javaxHttpServletRequestClass.isAssignableFrom(this.servletRequest.getClass());
        }
        if (this.jakartaHttpServletRequestClass != null) {
            return this.jakartaHttpServletRequestClass.isAssignableFrom(this.servletRequest.getClass());
        }
        return false;
    }

    public String getRemoteAddr() throws InvocationTargetException, IllegalAccessException {
        if (this.getRemoteAddr == null) {
            return "unknown";
        }
        return (String)this.getRemoteAddr.invoke(this.servletRequest, new Object[0]);
    }

    public String getRemoteHost() throws InvocationTargetException, IllegalAccessException {
        if (this.getRemoteHost == null) {
            return "unknown";
        }
        return (String)this.getRemoteHost.invoke(this.servletRequest, new Object[0]);
    }

    public void setAttribute(String name, Object value) throws InvocationTargetException, IllegalAccessException {
        if (this.setAttribute == null) {
            return;
        }
        this.setAttribute.invoke(this.servletRequest, name, value);
    }
}

