/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.ColumnDefinitions;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.TypeCodec;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.qubership.profiler.agent.Profiler;
import org.qubership.profiler.agent.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultResultSetFuture {
    private static transient Logger logger$profiler = LoggerFactory.getLogger(DefaultResultSetFuture.class);
    private Object threadLocalTraces$profiler;
    private static boolean methodsInitialized$profiler = false;
    private static boolean tracingAvailable$profiler = false;
    private static Method currentTraceContextxtractThreadLocalTraces$profiler;
    private static Method currentTraceContextlogThreadLocalTraces$profiler;
    private static boolean ableToParseBinds$profiler;
    private static Map<DataType.Name, TypeCodec> typeCodecs$profiler;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSet$profiler(Statement statement, long latency) {
        long lattencyMillis = latency / 1000000L;
        if (statement == null) {
            return;
        }
        this.ensureMethodsTracingMethodsInitialized$profiler();
        Profiler.enterWithDuration((String)"void com.datastax.driver.core.DefaultResultSetFuture.onSet() (DefaultResultSetFuture.java:333) [unknown jar]", (long)lattencyMillis);
        try {
            if (tracingAvailable$profiler) {
                currentTraceContextlogThreadLocalTraces$profiler.invoke(null, this.threadLocalTraces$profiler);
            }
            if (Profiler.getState().callInfo.waitTime > lattencyMillis) {
                lattencyMillis = 0L;
            }
            String query = null;
            String binds = null;
            if (statement instanceof RegularStatement) {
                query = ((RegularStatement)statement).getQueryString();
            } else if (statement instanceof BoundStatement) {
                BoundStatement bound = (BoundStatement)statement;
                query = bound.preparedStatement().getQueryString();
                binds = this.parseBinds$profiler(bound);
            }
            if (!StringUtils.isBlank((CharSequence)query)) {
                Profiler.event((Object)query, (String)"sql");
            }
            if (!StringUtils.isBlank(binds)) {
                Profiler.event(binds, (String)"binds");
            }
        }
        catch (Throwable t) {
            logger$profiler.error("Failed to log statement", t);
        }
        finally {
            Profiler.exit();
        }
    }

    private String parseBinds$profiler(BoundStatement bound) {
        if (!ableToParseBinds$profiler) {
            return "";
        }
        try {
            PreparedStatement preparedStatement = bound.preparedStatement();
            StringBuilder bindsBuilder = new StringBuilder();
            if (preparedStatement.getVariables().size() > 0) {
                List<ColumnDefinitions.Definition> defs = preparedStatement.getVariables().asList();
                for (int i = 0; i < defs.size(); ++i) {
                    ColumnDefinitions.Definition def = defs.get(i);
                    bindsBuilder.append(def.getType().name).append(": ").append(def.getName()).append(": ");
                    this.stringify$profiler(bindsBuilder, def, bound, i);
                }
            }
            return bindsBuilder.toString();
        }
        catch (NoSuchFieldError e) {
            if (logger$profiler.isDebugEnabled()) {
                logger$profiler.warn("Failed to log cassandra statement statement bindings. probably mismatch in a driver version", (Throwable)e);
            } else {
                logger$profiler.warn("Failed to log cassandra statement statement bindings. probably mismatch in a driver version");
            }
            ableToParseBinds$profiler = false;
            return "";
        }
    }

    private void stringify$profiler(StringBuilder result, ColumnDefinitions.Definition def, BoundStatement bound, int i) {
        TypeCodec codec = typeCodecs$profiler.get(def.getType().getName());
        if (codec == null) {
            result.append(">>>>").append(def.getType().getName().toString()).append(" not supported yet");
            return;
        }
        result.append(bound.get(i, codec));
    }

    public void postConstruct$profiler() throws NoSuchMethodException, InvocationTargetException, IllegalAccessException, ClassNotFoundException {
        this.ensureMethodsTracingMethodsInitialized$profiler();
        if (!tracingAvailable$profiler) {
            return;
        }
        this.threadLocalTraces$profiler = currentTraceContextxtractThreadLocalTraces$profiler.invoke(null, new Object[0]);
    }

    private void ensureMethodsTracingMethodsInitialized$profiler() {
        try {
            Class<?> currentTraceContextClass;
            if (methodsInitialized$profiler) {
                return;
            }
            try {
                currentTraceContextClass = Class.forName("brave.propagation.CurrentTraceContext");
            }
            catch (ClassNotFoundException e) {
                logger$profiler.info("Failed to find class \"brave.propagation.CurrentTraceContext\". Tracing not available. {}", (Object)e.getMessage());
                tracingAvailable$profiler = false;
                methodsInitialized$profiler = true;
                return;
            }
            try {
                currentTraceContextxtractThreadLocalTraces$profiler = currentTraceContextClass.getDeclaredMethod("extractThreadLocalTraces$profiler", new Class[0]);
                currentTraceContextlogThreadLocalTraces$profiler = currentTraceContextClass.getDeclaredMethod("logThreadLocalTraces$profiler", Object.class);
                currentTraceContextxtractThreadLocalTraces$profiler.setAccessible(true);
                currentTraceContextlogThreadLocalTraces$profiler.setAccessible(true);
                tracingAvailable$profiler = true;
            }
            catch (NoSuchMethodException e) {
                logger$profiler.info("Tracing not available: unable to find method. {}", (Object)e.getMessage());
                tracingAvailable$profiler = false;
            }
            methodsInitialized$profiler = true;
        }
        catch (Throwable t) {
            Profiler.pluginException((Throwable)t);
            logger$profiler.error("Exception during initialization of methods", t);
        }
    }

    public void handleException$profiler(Throwable t, Statement statement, long latency) {
        Profiler.logInfo((String)"DMNE reached 2");
        logger$profiler.error("Exception {}", t);
    }

    static {
        ableToParseBinds$profiler = true;
        typeCodecs$profiler = new HashMap<DataType.Name, TypeCodec>();
        typeCodecs$profiler.put(DataType.Name.ASCII, TypeCodec.ascii());
        typeCodecs$profiler.put(DataType.Name.BIGINT, TypeCodec.bigint());
        typeCodecs$profiler.put(DataType.Name.BLOB, TypeCodec.blob());
        typeCodecs$profiler.put(DataType.Name.BOOLEAN, TypeCodec.cboolean());
        typeCodecs$profiler.put(DataType.Name.COUNTER, TypeCodec.counter());
        typeCodecs$profiler.put(DataType.Name.DECIMAL, TypeCodec.decimal());
        typeCodecs$profiler.put(DataType.Name.DOUBLE, TypeCodec.cdouble());
        typeCodecs$profiler.put(DataType.Name.FLOAT, TypeCodec.cfloat());
        typeCodecs$profiler.put(DataType.Name.INT, TypeCodec.cint());
        typeCodecs$profiler.put(DataType.Name.TEXT, TypeCodec.varchar());
        typeCodecs$profiler.put(DataType.Name.TIMESTAMP, TypeCodec.timestamp());
        typeCodecs$profiler.put(DataType.Name.UUID, TypeCodec.uuid());
        typeCodecs$profiler.put(DataType.Name.VARCHAR, TypeCodec.varchar());
        typeCodecs$profiler.put(DataType.Name.VARINT, TypeCodec.varint());
        typeCodecs$profiler.put(DataType.Name.TIMEUUID, TypeCodec.timeUUID());
        typeCodecs$profiler.put(DataType.Name.INET, TypeCodec.inet());
        typeCodecs$profiler.put(DataType.Name.DATE, TypeCodec.date());
        typeCodecs$profiler.put(DataType.Name.TIME, TypeCodec.time());
        typeCodecs$profiler.put(DataType.Name.SMALLINT, TypeCodec.smallInt());
        typeCodecs$profiler.put(DataType.Name.TINYINT, TypeCodec.tinyInt());
        typeCodecs$profiler.put(DataType.Name.DURATION, TypeCodec.duration());
    }
}

