/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.cql;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.cql.ColumnDefinition;
import com.datastax.oss.driver.api.core.cql.ColumnDefinitions;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.internal.core.cql.DefaultBatchStatement;
import com.datastax.oss.driver.internal.core.cql.DefaultBoundStatement;
import com.datastax.oss.driver.internal.core.cql.DefaultSimpleStatement;
import org.qubership.profiler.agent.Profiler;
import org.qubership.profiler.agent.StringUtils;

public class CqlRequestHandler {
    public void sendRequest$profiler(Statement statement) {
        String query = null;
        String binds = null;
        if (statement instanceof DefaultSimpleStatement) {
            query = ((DefaultSimpleStatement)((Object)statement)).getQuery();
        } else if (statement instanceof DefaultBatchStatement) {
            query = "null";
        } else if (statement instanceof DefaultBoundStatement) {
            DefaultBoundStatement defaultBoundStatement = (DefaultBoundStatement)((Object)statement);
            query = defaultBoundStatement.getPreparedStatement().getQuery();
            binds = this.parseBinds$profiler(defaultBoundStatement);
        }
        if (!StringUtils.isBlank((CharSequence)query)) {
            Profiler.event((Object)query, (String)"sql");
        }
        if (!StringUtils.isBlank(binds)) {
            Profiler.event(binds, (String)"binds");
        }
    }

    private String parseBinds$profiler(DefaultBoundStatement bound) {
        ColumnDefinitions columnDefinition = bound.getPreparedStatement().getVariableDefinitions();
        StringBuilder bindsBuilder = new StringBuilder();
        if (columnDefinition.size() > 0) {
            for (int i = 0; i < columnDefinition.size(); ++i) {
                ColumnDefinition definition = columnDefinition.get(i);
                DataType type = definition.getType();
                CqlIdentifier identifier = definition.getName();
                Object value = bound.getObject(i);
                bindsBuilder.append(type).append(": ").append(identifier).append(": ").append(value).append("\n");
            }
        }
        return bindsBuilder.toString();
    }
}

