/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.core.v3;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.sql.SQLException;
import org.postgresql.core.ParameterList;
import org.postgresql.core.Query;
import org.postgresql.core.ResultHandler;
import org.postgresql.core.Utils;
import org.postgresql.core.v3.SimpleParameterList;
import org.postgresql.core.v3.V3ParameterList;
import org.qubership.profiler.agent.Profiler;

public class QueryExecutorImpl {
    public static final int MAX_BIND_SIZE$profiler = 4096;
    private static volatile Boolean pre4230$profiler;
    static transient Field detailMessage$profiler;
    static transient boolean hasNativeSql$profiler;
    static transient Method getNativeSql$profiler;

    private static String getSql$profiler(Query query) {
        if (query == null) {
            return null;
        }
        if (!hasNativeSql$profiler) {
            hasNativeSql$profiler = true;
            try {
                getNativeSql$profiler = query.getClass().getMethod("getNativeSql", new Class[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        if (getNativeSql$profiler == null) {
            return query.toString();
        }
        try {
            return (String)getNativeSql$profiler.invoke((Object)query, new Object[0]);
        }
        catch (Throwable e) {
            return query.toString();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getBinds$profiler(ParameterList parameters) {
        if (parameters == null) {
            return null;
        }
        int count = parameters.getParameterCount();
        if (count == 0) {
            return null;
        }
        SimpleParameterList[] subparams = ((V3ParameterList)parameters).getSubparams();
        StringBuilder sb = new StringBuilder();
        if (subparams == null) {
            if (!(parameters instanceof SimpleParameterList)) return parameters.toString();
            QueryExecutorImpl.stringifyParameterList$profiler((SimpleParameterList)parameters, sb);
            return sb.toString();
        } else {
            for (int i = 0; i < subparams.length; ++i) {
                if (i > 0) {
                    sb.append('\n');
                }
                sb.append("/* query#").append(i).append(" */");
                SimpleParameterList param = subparams[i];
                if (param == null) continue;
                QueryExecutorImpl.stringifyParameterList$profiler(param, sb);
            }
        }
        return sb.toString();
    }

    public static void stringifyParameterList$profiler(SimpleParameterList spl, StringBuilder target) {
        int[] paramTypes = spl.getParamTypes();
        Object[] values = spl.getValues();
        target.append("<[");
        for (int i = 0; i < paramTypes.length; ++i) {
            if (i != 0) {
                target.append(", ");
            }
            if (values[i] instanceof String) {
                QueryExecutorImpl.appendTrimmed$profiler((String)values[i], target);
                continue;
            }
            if (values[i] instanceof String[]) {
                String[] stringValues = (String[])values[i];
                target.append("[");
                for (int j = 0; j < stringValues.length; ++j) {
                    if (j != 0) {
                        target.append(", ");
                    }
                    QueryExecutorImpl.appendTrimmed$profiler(stringValues[j], target);
                }
                target.append("]");
                continue;
            }
            String potentiallyBigString = spl.toString(i + 1, true);
            QueryExecutorImpl.appendTrimmed$profiler(potentiallyBigString, target, false);
        }
        target.append("]>");
    }

    private static void appendTrimmed$profiler(String toAppend, StringBuilder target) {
        QueryExecutorImpl.appendTrimmed$profiler(toAppend, target, true);
    }

    private static void appendTrimmed$profiler(String toAppend, StringBuilder target, boolean escape) {
        if (toAppend.length() > 4096) {
            toAppend = toAppend.substring(0, 4096) + "...";
        }
        if (escape) {
            target.append('\'');
            try {
                Utils.escapeLiteral(target, toAppend, true);
            }
            catch (SQLException sqle) {
                target.append(toAppend);
            }
            target.append('\'');
        } else {
            target.append(toAppend);
        }
    }

    private static boolean isPre4230Version$profiler() {
        Boolean pre4230 = pre4230$profiler;
        if (pre4230 == null) {
            try {
                QueryExecutorImpl.class.getMethod("execute", Query.class, ParameterList.class, ResultHandler.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Boolean.TYPE);
                pre4230$profiler = pre4230 = Boolean.valueOf(false);
            }
            catch (Throwable t) {
                pre4230$profiler = pre4230 = Boolean.valueOf(true);
            }
        }
        return pre4230;
    }

    public static void dumpSqlConditional$profiler(Query query) {
        if (QueryExecutorImpl.isPre4230Version$profiler()) {
            QueryExecutorImpl.dumpSql$profiler(query);
        }
    }

    public static void dumpSqlConditional$profiler(Query[] queries) {
        if (QueryExecutorImpl.isPre4230Version$profiler()) {
            QueryExecutorImpl.dumpSql$profiler(queries);
        }
    }

    public static void dumpBindsConditional$profiler(ParameterList parameters) {
        if (QueryExecutorImpl.isPre4230Version$profiler()) {
            QueryExecutorImpl.dumpBinds$profiler(parameters);
        }
    }

    public static void dumpBindsConditional$profiler(ParameterList[] parameters) {
        if (QueryExecutorImpl.isPre4230Version$profiler()) {
            QueryExecutorImpl.dumpBinds$profiler(parameters);
        }
    }

    public void handleExceptionConditional$profiler(Throwable t, Query query, ParameterList params) {
        if (QueryExecutorImpl.isPre4230Version$profiler()) {
            this.handleException$profiler(t, query, params);
        }
    }

    public void handleExceptionConditional$profiler(Throwable t, Query[] queries, ParameterList[] params) {
        if (QueryExecutorImpl.isPre4230Version$profiler()) {
            this.handleException$profiler(t, queries, params);
        }
    }

    public static void dumpSql$profiler(Query query) {
        Profiler.event((Object)QueryExecutorImpl.getSql$profiler(query), (String)"sql");
    }

    public static void dumpSql$profiler(Query[] queries) {
        for (Query query : queries) {
            Profiler.event((Object)QueryExecutorImpl.getSql$profiler(query), (String)"sql");
        }
    }

    public static void dumpBinds$profiler(ParameterList parameters) {
        String s = QueryExecutorImpl.getBinds$profiler(parameters);
        if (s == null) {
            return;
        }
        Profiler.event((Object)s, (String)"binds");
    }

    public static void dumpBinds$profiler(ParameterList[] parameters) {
        for (ParameterList parameter : parameters) {
            String s = QueryExecutorImpl.getBinds$profiler(parameter);
            if (s == null) {
                return;
            }
            Profiler.event((Object)s, (String)"binds");
        }
    }

    public void handleException$profiler(Throwable t, Query query, ParameterList params) {
        String message = t.getMessage();
        if (message == null) {
            message = "";
        }
        if (message.contains("\n\tsql=")) {
            return;
        }
        message = message + "\n\tsql=" + QueryExecutorImpl.getSql$profiler(query) + "\n\tbinds=" + QueryExecutorImpl.getBinds$profiler(params);
        Profiler.event((Object)message, (String)"exception");
        try {
            Field detailMessage = detailMessage$profiler;
            if (detailMessage == null) {
                detailMessage = Class.forName("java.lang.Throwable").getDeclaredField("detailMessage");
                detailMessage.setAccessible(true);
                detailMessage$profiler = detailMessage;
            }
            detailMessage.set(t, message);
            return;
        }
        catch (Throwable detailMessage) {
            String originalSQLState = null;
            if (t instanceof SQLException) {
                originalSQLState = ((SQLException)t).getSQLState();
            }
            if (t.getCause() == null) {
                SQLException details = new SQLException(message, originalSQLState);
                try {
                    t.initCause(details);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                return;
            }
            SQLException sqlException = new SQLException(message, originalSQLState, t);
            Profiler.logError((String)"", (Throwable)sqlException);
            return;
        }
    }

    public void handleException$profiler(Throwable t, Query[] queries, ParameterList[] params) {
        for (int i = 0; i < queries.length; ++i) {
            if (params.length <= i) continue;
            this.handleException$profiler(t, queries[i], params[i]);
        }
    }
}

