/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import org.qubership.profiler.agent.CallInfo;
import org.qubership.profiler.agent.LocalState;
import org.qubership.profiler.agent.Profiler;
import org.qubership.profiler.agent.StringUtils;

public abstract class PgConnection
implements Connection {
    protected transient Statement statement$profiler;
    protected static int SET_E2E$profiler;
    protected String prevUser$profiler;
    protected String prevAppName$profiler;
    protected SimpleDateFormat sdf$profiler;

    void setSessionInfo$profiler() {
        LocalState state = Profiler.getState();
        CallInfo callInfo = state.callInfo;
        boolean connectionIsOk = callInfo.checkConnection((Connection)this);
        if (!callInfo.anyFieldChanged() && connectionIsOk) {
            return;
        }
        if (this.statement$profiler == null) {
            try {
                this.statement$profiler = this.createStatement();
            }
            catch (SQLException e) {
                Profiler.event((Object)StringUtils.throwableToString((Throwable)e), (String)"exception: create setSessionInfo$profiler");
            }
            this.sdf$profiler = new SimpleDateFormat("MMddHHmmss");
        }
        try {
            String ncUser = String.valueOf(callInfo.getNcUser());
            if (!ncUser.equals(this.prevUser$profiler)) {
                this.prevUser$profiler = ncUser;
                this.statement$profiler.execute("set session \"esc.nc.user\" = '" + ncUser.replace('\'', '\"') + "'");
            }
        }
        catch (SQLException e) {
            Profiler.event((Object)StringUtils.throwableToString((Throwable)e), (String)"exception: setSessionInfo$profiler.executeUpdate");
        }
        if (SET_E2E$profiler == 1) {
            return;
        }
        if (SET_E2E$profiler == 0) {
            SET_E2E$profiler = Boolean.getBoolean("org.qubership.execution-statistics-collector.postgresql.e2e.disabled") ? 1 : 2;
        }
        try {
            long now = System.currentTimeMillis();
            StringBuilder sb = new StringBuilder(100);
            sb.append(state.thread.getId());
            sb.append(',');
            sb.append(this.sdf$profiler.format(now));
            sb.append(',');
            sb.append(state.shortThreadName.substring(0, Math.min(15, state.shortThreadName.length())));
            sb.append(',');
            sb.append(now);
            String appName = sb.toString();
            if (!appName.equals(this.prevAppName$profiler)) {
                this.prevAppName$profiler = appName;
                String appNameString = appName.replace('\'', '\"');
                this.statement$profiler.execute("set session application_name = '" + appNameString + "'");
                Profiler.event((Object)appNameString, (String)"pg_application_name");
            }
        }
        catch (SQLException e) {
            Profiler.pluginException((Throwable)e);
        }
    }
}

