/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jms.listener;

import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.TextMessage;
import org.qubership.profiler.agent.Profiler;
import org.qubership.profiler.agent.ProfilerData;
import org.qubership.profiler.agent.StringUtils;

public class AbstractMessageListenerContainer {
    public native Object getMessageListener();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpMessage$profiler(Message message) {
        String consumer = null;
        String destination = null;
        String replyTo = null;
        String messageId = null;
        String correlationId = null;
        long timestamp = 0L;
        String unitOfOrder = null;
        String text = null;
        String textFragment = null;
        try {
            Destination replyDestination;
            Profiler.enter((String)"void weblogic.jms.client.JMSSession.dumpMessage$profiler(MessageListener,Message) (JMSSession.java:9) [unknown.jar]");
            consumer = this.getMessageListener() == null ? null : String.valueOf(this.getMessageListener());
            Destination messageDestination = message.getJMSDestination();
            if (messageDestination != null) {
                destination = messageDestination.toString();
            }
            if ((replyDestination = message.getJMSReplyTo()) != null) {
                replyTo = replyDestination.toString();
            }
            messageId = message.getJMSMessageID();
            correlationId = message.getJMSCorrelationID();
            timestamp = message.getJMSTimestamp();
            unitOfOrder = message.getStringProperty("JMS_BEA_UnitOfOrder");
            if (message instanceof TextMessage && ProfilerData.LOG_JMS_TEXT) {
                TextMessage textMessage = (TextMessage)message;
                text = textMessage.getText();
                if (text == null || text.length() <= 1500) {
                    textFragment = text;
                    text = null;
                } else {
                    textFragment = text.substring(0, 997) + "...";
                }
            }
        }
        catch (Throwable t) {
            Profiler.pluginException((Throwable)t);
        }
        finally {
            Profiler.exit();
        }
        Profiler.event((Object)consumer, (String)"jms.consumer");
        Profiler.event(messageId, (String)"jms.messageid");
        Profiler.event(correlationId, (String)"jms.correlationid");
        Profiler.event(replyTo, (String)"jms.replyto");
        if (timestamp != 0L) {
            Profiler.event((Object)new Long(timestamp), (String)"jms.timestamp");
        }
        if (destination != null) {
            Profiler.event((Object)destination, (String)"jms.destination");
            Profiler.getState().callInfo.setCliendId("JMS " + StringUtils.right((String)destination, (int)60));
        }
        if (unitOfOrder != null && unitOfOrder.length() > 0) {
            Profiler.event((Object)unitOfOrder, (String)"jms.unitoforder");
        }
        Profiler.event(text, (String)"jms.text");
        Profiler.event(textFragment, (String)"jms.text.fragment");
    }
}

