/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Modifier;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import org.openjdk.jmc.common.IDescribable;
import org.openjdk.jmc.common.IMCFrame;
import org.openjdk.jmc.common.IMCMethod;
import org.openjdk.jmc.common.IMCPackage;
import org.openjdk.jmc.common.IMCStackTrace;
import org.openjdk.jmc.common.IMCType;
import org.openjdk.jmc.common.item.IAccessorKey;
import org.openjdk.jmc.common.item.IItem;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.item.IItemIterable;
import org.openjdk.jmc.common.item.IMemberAccessor;
import org.openjdk.jmc.common.item.IType;
import org.openjdk.jmc.common.item.ItemToolkit;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.util.FormatToolkit;
import org.openjdk.jmc.flightrecorder.CouldNotLoadRecordingException;
import org.openjdk.jmc.flightrecorder.IParserStats;
import org.openjdk.jmc.flightrecorder.JfrLoaderToolkit;
import org.openjdk.jmc.flightrecorder.parser.IParserExtension;
import org.openjdk.jmc.flightrecorder.parser.ParserExtensionRegistry;
import org.openjdk.jmc.flightrecorder.parser.filter.FilterExtension;
import org.openjdk.jmc.flightrecorder.parser.filter.IOnLoadFilter;
import org.openjdk.jmc.flightrecorder.parser.filter.OnLoadFilters;

public final class RecordingPrinter {
    private final Verbosity verbosity;
    private final boolean formatValues;
    private final IOnLoadFilter recordingFilter;
    private final PrintWriter out;

    public RecordingPrinter(PrintWriter output, Verbosity verbosity, boolean formatValues, IOnLoadFilter recordingFilter) {
        this.out = output;
        this.verbosity = verbosity;
        this.formatValues = formatValues;
        this.recordingFilter = recordingFilter;
    }

    public RecordingPrinter(PrintWriter output, Verbosity verbosity, boolean formatValues) {
        this(output, verbosity, formatValues, null);
    }

    public static void main(String[] args) throws IOException, InterruptedException, CouldNotLoadRecordingException {
        if (args.length > 0) {
            try {
                IItemCollection events;
                RecordingPrinter printer = RecordingPrinter.buildFromOptions(new PrintWriter(System.out), args);
                File file = new File(args[args.length - 1]);
                if (printer.recordingFilter != null) {
                    ArrayList<IParserExtension> extensions = new ArrayList<IParserExtension>(ParserExtensionRegistry.getParserExtensions());
                    extensions.add(new FilterExtension(printer.recordingFilter));
                    events = JfrLoaderToolkit.loadEvents(Arrays.asList(file), extensions);
                } else {
                    events = JfrLoaderToolkit.loadEvents(Arrays.asList(file));
                }
                printer.print(events);
                return;
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        RecordingPrinter.printHelp();
    }

    public void print(IItemCollection events) {
        if (this.verbosity == Verbosity.SUMMARY) {
            this.printSummary((IParserStats)((Object)events));
            return;
        }
        this.out.println("<?xml version=\"1.0\"?>");
        Iterator itemIterable = events.iterator();
        while (itemIterable.hasNext()) {
            Iterator itemIterator = ((IItemIterable)itemIterable.next()).iterator();
            while (itemIterator.hasNext()) {
                this.printEvent((IItem)itemIterator.next());
                this.out.println();
            }
        }
        this.out.flush();
    }

    private void printSummary(IParserStats parserStats) {
        this.out.printf("Version: %d.%d\n", parserStats.getMajorVersion(), parserStats.getMinorVersion());
        this.out.printf("Chunks: %d\n", parserStats.getChunkCount());
        TreeSet eventStatsSet = new TreeSet((o1, o2) -> Long.compare(o2.getCount(), o1.getCount()));
        parserStats.forEachEventType(eventStats -> eventStatsSet.add(eventStats));
        int minWidth = 0;
        for (IParserStats.IEventStats eventStats2 : eventStatsSet) {
            minWidth = Math.max(minWidth, eventStats2.getName().length());
        }
        this.out.println();
        String header = "      Count  Size (bytes) ";
        String typeHeader = " Event Type";
        minWidth = Math.max(minWidth, typeHeader.length());
        this.out.println(typeHeader + this.pad(minWidth - typeHeader.length(), ' ') + header);
        this.out.println(this.pad(minWidth + header.length(), '='));
        for (IParserStats.IEventStats eventStats3 : eventStatsSet) {
            this.out.printf(" %-" + minWidth + "s%10d  %12d\n", eventStats3.getName(), eventStats3.getCount(), eventStats3.getTotalSize());
        }
        this.out.flush();
    }

    private String pad(int count, char c) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < count; ++i) {
            sb.append(c);
        }
        return sb.toString();
    }

    private static RecordingPrinter buildFromOptions(PrintWriter output, String[] args) throws ParseException {
        Verbosity verbosity = Verbosity.HIGH;
        IOnLoadFilter recordingFilter = null;
        boolean formatValues = false;
        for (int n = 0; n < args.length - 1; ++n) {
            if (args[n].equals("-formatValues")) {
                formatValues = true;
                continue;
            }
            if (args[n].equals("-brief")) {
                verbosity = Verbosity.LOW;
                continue;
            }
            if (args[n].equals("-includeevents")) {
                recordingFilter = OnLoadFilters.includeEvents(Arrays.asList(args[++n].split(",")));
                continue;
            }
            if (args[n].equals("-summary")) {
                verbosity = Verbosity.SUMMARY;
                continue;
            }
            throw new ParseException("Unknown command " + args[n], n);
        }
        return new RecordingPrinter(output, verbosity, formatValues, recordingFilter);
    }

    private static void printHelp() {
        System.out.println("Usage:");
        System.out.println("filename The name of the flight recording file to print.");
    }

    public void printEvent(IItem e) {
        this.out.println("<event name=\"" + e.getType().getName() + "\" path=\"" + e.getType().getIdentifier() + "\">");
        if (this.verbosity != Verbosity.LOW) {
            this.printValues(e);
        }
        this.out.print("</event>");
    }

    private void printValues(IItem event) {
        IType<IItem> itemType = ItemToolkit.getItemType(event);
        for (Map.Entry<IAccessorKey<?>, IDescribable> e : itemType.getAccessorKeys().entrySet()) {
            IMemberAccessor<?, IItem> accessor = itemType.getAccessor(e.getKey());
            this.printValue(e.getKey(), e.getValue(), accessor.getMember(event));
        }
    }

    private void printValue(IAccessorKey<?> attribute, IDescribable desc, Object value) {
        if (value instanceof IMCStackTrace) {
            this.printTrace((IMCStackTrace)value);
        } else {
            this.out.print("  <" + attribute.getIdentifier() + " name=\"" + desc.getName() + "\">");
            if (value == null) {
                this.out.print("null");
            } else {
                this.out.print(this.stringify("", value));
            }
            this.out.println("</" + attribute.getIdentifier() + ">");
        }
    }

    private String stringify(String indent, Object value) {
        if (value instanceof IMCMethod) {
            return indent + RecordingPrinter.stringifyMethod((IMCMethod)value);
        }
        if (value instanceof IMCType) {
            return indent + RecordingPrinter.stringifyType((IMCType)value);
        }
        if (value instanceof IQuantity) {
            if (this.formatValues) {
                return ((IQuantity)value).displayUsing("auto");
            }
            return ((IQuantity)value).persistableString();
        }
        if (value instanceof IDescribable) {
            String name = ((IDescribable)value).getName();
            return name != null ? name : value.toString();
        }
        if (value == null) {
            return "null";
        }
        if (value.getClass().isArray()) {
            StringBuffer buffer = new StringBuffer();
            Object[] values = (Object[])value;
            buffer.append(" [" + values.length + "]");
            for (Object o : values) {
                buffer.append(indent);
                buffer.append(this.stringify(indent + "  ", o));
            }
            return buffer.toString();
        }
        return value.toString();
    }

    private void printTrace(IMCStackTrace trace) {
        this.out.println("  <stackTrace>");
        if (this.verbosity == Verbosity.HIGH) {
            for (IMCFrame iMCFrame : trace.getFrames()) {
                RecordingPrinter.printFrame("     ", iMCFrame, this.out);
            }
        }
        this.out.println("  </stackTrace>");
    }

    private static void printFrame(String indent, IMCFrame frame, PrintWriter out) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(indent);
        buffer.append("<frame ");
        Integer lineNumber = frame.getFrameLineNumber();
        IMCMethod method = frame.getMethod();
        buffer.append("method=\"");
        if (method != null) {
            buffer.append(RecordingPrinter.stringifyMethod(method));
        } else {
            buffer.append("null");
        }
        buffer.append(" line=\"");
        buffer.append(String.valueOf(lineNumber));
        buffer.append("\" type=\"" + frame.getType() + "\"/>");
        out.println(buffer.toString());
    }

    private static String stringifyType(IMCType type) {
        StringBuffer sb = new StringBuffer();
        sb.append(RecordingPrinter.formatPackage(type.getPackage()));
        sb.append(".");
        sb.append(String.valueOf(type.getTypeName()));
        return sb.toString();
    }

    private static String stringifyMethod(IMCMethod method) {
        StringBuffer buffer = new StringBuffer();
        Integer modifier = method.getModifier();
        buffer.append(RecordingPrinter.formatPackage(method.getType().getPackage()));
        buffer.append(".");
        buffer.append(method.getType().getTypeName());
        buffer.append("#");
        buffer.append(method.getMethodName());
        buffer.append(method.getFormalDescriptor());
        buffer.append("\"");
        if (modifier != null) {
            buffer.append(" modifier=\"");
            buffer.append(Modifier.toString(method.getModifier()));
            buffer.append("\"");
        }
        return buffer.toString();
    }

    private static String formatPackage(IMCPackage mcPackage) {
        return FormatToolkit.getPackage(mcPackage);
    }

    public static enum Verbosity {
        HIGH,
        MEDIUM,
        LOW,
        SUMMARY;

    }
}

