/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.internal.parser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.openjdk.jmc.common.collection.FastAccessNumberMap;
import org.openjdk.jmc.common.item.IAttribute;
import org.openjdk.jmc.common.item.IItem;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.IRange;
import org.openjdk.jmc.flightrecorder.CouldNotLoadRecordingException;
import org.openjdk.jmc.flightrecorder.JfrAttributes;
import org.openjdk.jmc.flightrecorder.internal.EventArray;
import org.openjdk.jmc.flightrecorder.internal.EventArrays;
import org.openjdk.jmc.flightrecorder.internal.parser.ParserStats;
import org.openjdk.jmc.flightrecorder.internal.parser.RepositoryBuilder;
import org.openjdk.jmc.flightrecorder.internal.util.CanonicalConstantMap;
import org.openjdk.jmc.flightrecorder.parser.IConstantPoolExtension;
import org.openjdk.jmc.flightrecorder.parser.IEventSinkFactory;
import org.openjdk.jmc.flightrecorder.parser.IParserExtension;

public class LoaderContext {
    private final RepositoryBuilder repositoryBuilder = new RepositoryBuilder();
    private final IEventSinkFactory sinkFactory;
    private final ConcurrentHashMap<Object, CanonicalConstantMap<Object>> constantsByType = new ConcurrentHashMap();
    private final boolean hideExperimentals;
    private final List<? extends IParserExtension> extensions;
    private final List<IConstantPoolExtension> constPoolExtensions = new CopyOnWriteArrayList<IConstantPoolExtension>();
    private final Set<IRange<IQuantity>> chunkRanges;
    private final ParserStats parserStats = new ParserStats();

    public LoaderContext(List<? extends IParserExtension> extensions, boolean hideExperimentals) {
        this.extensions = extensions;
        this.hideExperimentals = hideExperimentals;
        IEventSinkFactory sinkFactory = this.repositoryBuilder;
        for (int i = extensions.size() - 1; i >= 0; --i) {
            sinkFactory = extensions.get(i).getEventSinkFactory(sinkFactory);
        }
        for (IParserExtension iParserExtension : extensions) {
            IConstantPoolExtension constantPoolExtension = iParserExtension.createConstantPoolExtension();
            if (constantPoolExtension == null) continue;
            this.constPoolExtensions.add(constantPoolExtension);
        }
        this.sinkFactory = sinkFactory;
        this.chunkRanges = new HashSet<IRange<IQuantity>>();
    }

    public CanonicalConstantMap<Object> getConstantPool(Object poolKey) {
        CanonicalConstantMap<Object> newMap = new CanonicalConstantMap<Object>();
        CanonicalConstantMap existing = this.constantsByType.putIfAbsent(poolKey, newMap);
        return existing == null ? newMap : existing;
    }

    public boolean hideExperimentals() {
        return this.hideExperimentals;
    }

    public String getValueInterpretation(String eventTypeId, String fieldId) {
        for (IParserExtension iParserExtension : this.extensions) {
            String vi = iParserExtension.getValueInterpretation(eventTypeId, fieldId);
            if (vi == null) continue;
            return vi;
        }
        return null;
    }

    public Object constantRead(long constantIndex, Object constant, String eventTypeId) {
        Object newConstant = constant;
        for (IConstantPoolExtension m : this.constPoolExtensions) {
            newConstant = m.constantRead(constantIndex, newConstant, eventTypeId);
        }
        return newConstant;
    }

    public Object constantReferenced(Object constant, String poolName, String eventTypeId) {
        Object newConstant = constant;
        for (IConstantPoolExtension m : this.constPoolExtensions) {
            newConstant = m.constantReferenced(newConstant, poolName, eventTypeId);
        }
        return newConstant;
    }

    public Object constantResolved(Object constant, String poolName, String eventTypeId) {
        Object newConstant = constant;
        for (IConstantPoolExtension m : this.constPoolExtensions) {
            newConstant = m.constantResolved(newConstant, poolName, eventTypeId);
        }
        return newConstant;
    }

    public void allConstantPoolsResolved(Map<String, FastAccessNumberMap<Object>> constantPools) {
        for (IConstantPoolExtension m : this.constPoolExtensions) {
            m.allConstantPoolsResolved(constantPools);
        }
    }

    public IEventSinkFactory getSinkFactory() {
        return this.sinkFactory;
    }

    public void addChunkRange(IRange<IQuantity> chunkRange) {
        this.chunkRanges.add(chunkRange);
    }

    public EventArrays buildEventArrays() throws CouldNotLoadRecordingException {
        this.sinkFactory.flush();
        Iterator<RepositoryBuilder.EventTypeEntry> eventTypes = this.repositoryBuilder.getEventTypes();
        ArrayList<EventArray> eventArrays = new ArrayList<EventArray>();
        while (eventTypes.hasNext()) {
            Collection<IItem[]> sortedArrays;
            RepositoryBuilder.EventTypeEntry ete = eventTypes.next();
            ete.eventType.addExtraAttribute(0, JfrAttributes.EVENT_TYPE);
            List<IAttribute<?>> attributes = ete.eventType.getAttributes();
            if (attributes.contains(JfrAttributes.START_TIME)) {
                int endTimeIndex = attributes.indexOf(JfrAttributes.END_TIME);
                int durationIndex = attributes.indexOf(JfrAttributes.DURATION);
                if (endTimeIndex >= 0 && durationIndex < 0) {
                    ete.eventType.addExtraAttribute(endTimeIndex, JfrAttributes.DURATION);
                } else if (durationIndex >= 0 && endTimeIndex < 0) {
                    ete.eventType.addExtraAttribute(durationIndex + 1, JfrAttributes.END_TIME);
                }
            }
            if ((sortedArrays = ete.buildSortedArrays()).isEmpty()) {
                eventArrays.add(new EventArray(new IItem[0], ete.eventType, ete.category));
                continue;
            }
            for (IItem[] ea : sortedArrays) {
                eventArrays.add(new EventArray(ea, ete.eventType, ete.category));
            }
        }
        return new EventArrays(eventArrays.toArray(new EventArray[eventArrays.size()]), this.chunkRanges, this.parserStats);
    }

    public void incChunkCount() {
        this.parserStats.incChunkCount();
    }

    public void updateEventStats(String eventTypeName, long size) {
        this.parserStats.updateEventStats(eventTypeName, size);
    }

    public void addTypeConstantPool(long id, String name, FastAccessNumberMap<Object> constantPool) {
        this.parserStats.addConstantPool(id, name, constantPool);
    }

    public ParserStats getParserStats() {
        return this.parserStats;
    }

    public void setVersion(short majorVersion, short minorVersion) {
        this.parserStats.setVersion(majorVersion, minorVersion);
    }

    public void setSkippedEventCount(long skippedEventCount) {
        this.parserStats.setSkippedEventCount(skippedEventCount);
    }

    public void addEntryPoolSize(String typeIdentifier, long size) {
        this.parserStats.addEntryPoolSize(typeIdentifier, size);
    }

    public void addConstantPoolExtensions() {
        for (IConstantPoolExtension ext : this.constPoolExtensions) {
            ext.eventsLoaded();
            this.parserStats.addConstantPoolExtension(ext);
        }
    }
}

