/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.internal.parser;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import org.openjdk.jmc.common.IDescribable;
import org.openjdk.jmc.common.IMCFrame;
import org.openjdk.jmc.common.IMCStackTrace;
import org.openjdk.jmc.common.collection.FastAccessNumberMap;
import org.openjdk.jmc.common.item.IAccessorKey;
import org.openjdk.jmc.common.item.IAttribute;
import org.openjdk.jmc.common.item.ICanonicalAccessorFactory;
import org.openjdk.jmc.common.item.IItem;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.item.IMemberAccessor;
import org.openjdk.jmc.common.item.IType;
import org.openjdk.jmc.common.item.ItemCollectionToolkit;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.common.util.MemberAccessorToolkit;
import org.openjdk.jmc.flightrecorder.IParserStats;
import org.openjdk.jmc.flightrecorder.parser.IConstantPoolExtension;
import org.openjdk.jmc.flightrecorder.stacktrace.FrameSeparator;
import org.openjdk.jmc.flightrecorder.stacktrace.StacktraceFormatToolkit;

public class ParserStats {
    private short majorVersion;
    private short minorVersion;
    private final AtomicInteger chunkCount = new AtomicInteger();
    private final AtomicLong skippedEventCount = new AtomicLong();
    private final ConcurrentHashMap<String, EventTypeStats> statsByType = new ConcurrentHashMap();
    private final ConcurrentLinkedDeque<ConstantPoolInfo> constantPoolInfoList = new ConcurrentLinkedDeque();
    private final ConcurrentHashMap<String, Long> entryPoolSizeByType = new ConcurrentHashMap();
    private IItemCollection poolStats;
    private IItemCollection constants;
    private Map<String, IConstantPoolExtension> constantPoolExtensions = new ConcurrentHashMap<String, IConstantPoolExtension>();

    public void setVersion(short majorVersion, short minorVersion) {
        this.majorVersion = majorVersion;
        this.minorVersion = minorVersion;
    }

    public void incChunkCount() {
        this.chunkCount.incrementAndGet();
    }

    public void setSkippedEventCount(long skippedEventCount) {
        this.skippedEventCount.addAndGet(skippedEventCount);
    }

    public void updateEventStats(String eventTypeName, long size) {
        this.statsByType.compute(eventTypeName, (key, stats) -> {
            if (stats == null) {
                return new EventTypeStats(eventTypeName, size);
            }
            stats.add(size);
            return stats;
        });
    }

    public void addConstantPool(long id, String name, FastAccessNumberMap<Object> constantPool) {
        this.constantPoolInfoList.add(new ConstantPoolInfo(id, name, constantPool));
    }

    public void addEntryPoolSize(String typeIdentifier, long size) {
        this.entryPoolSizeByType.compute(typeIdentifier, (key, value) -> {
            if (value == null) {
                return size;
            }
            return value + size;
        });
    }

    public void addConstantPoolExtension(IConstantPoolExtension extension) {
        this.constantPoolExtensions.put(extension.getId(), extension);
    }

    public void forEachEventType(Consumer<IParserStats.IEventStats> consumer) {
        for (EventTypeStats eventStats : this.statsByType.values()) {
            consumer.accept(eventStats);
        }
    }

    public short getMajorVersion() {
        return this.majorVersion;
    }

    public short getMinorVersion() {
        return this.minorVersion;
    }

    public int getChunkCount() {
        return this.chunkCount.get();
    }

    public long getSkippedEventCount() {
        return this.skippedEventCount.get();
    }

    public long getCount(String eventTypeName) {
        EventTypeStats stats = this.statsByType.get(eventTypeName);
        if (stats == null) {
            return 0L;
        }
        return stats.count;
    }

    public long getTotalSize(String eventTypeName) {
        EventTypeStats stats = this.statsByType.get(eventTypeName);
        if (stats == null) {
            return 0L;
        }
        return stats.totalSize;
    }

    public IItemCollection getConstantPools() {
        if (this.poolStats == null) {
            HashMap<String, ConstPoolItem> poolStatsByName = new HashMap<String, ConstPoolItem>();
            for (ConstantPoolInfo info : this.constantPoolInfoList) {
                ConstPoolItem poolItem = poolStatsByName.computeIfAbsent(info.name, key -> this.createPoolItem(info));
                poolItem.count += this.getConstantPoolCount(info.constantPool);
            }
            this.poolStats = ItemCollectionToolkit.build(poolStatsByName.values().stream());
        }
        return this.poolStats;
    }

    public IItemCollection getConstants() {
        if (this.constants == null) {
            ArrayList<ConstantItem> items = new ArrayList<ConstantItem>();
            for (ConstantPoolInfo info : this.constantPoolInfoList) {
                for (Object value : info.constantPool) {
                    items.add(new ConstantItem(info.name, value));
                }
            }
            this.constants = ItemCollectionToolkit.build(items.stream());
        }
        return this.constants;
    }

    public Map<String, IConstantPoolExtension> getConstantPoolExtensions() {
        return this.constantPoolExtensions;
    }

    private ConstPoolItem createPoolItem(ConstantPoolInfo info) {
        Long totalSize = this.entryPoolSizeByType.get(info.name);
        long entrySize = totalSize != null ? totalSize : 0L;
        return new ConstPoolItem(info.name, 0L, entrySize);
    }

    private long getConstantPoolCount(FastAccessNumberMap<Object> constantPool) {
        Iterator<Object> iterator = constantPool.iterator();
        int count = 0;
        while (iterator.hasNext()) {
            ++count;
            iterator.next();
        }
        return count;
    }

    private static class ConstantPoolInfo {
        final long id;
        final String name;
        final FastAccessNumberMap<Object> constantPool;

        public ConstantPoolInfo(long id, String name, FastAccessNumberMap<Object> constantPool) {
            this.id = id;
            this.name = name;
            this.constantPool = constantPool;
        }
    }

    private static class EventTypeStats
    implements IParserStats.IEventStats {
        private final String eventTypeName;
        private long count;
        private long totalSize;

        public EventTypeStats(String eventTypeName, long size) {
            this.eventTypeName = eventTypeName;
            this.count = 1L;
            this.totalSize = size;
        }

        public void add(long size) {
            ++this.count;
            this.totalSize += size;
        }

        @Override
        public String getName() {
            return this.eventTypeName;
        }

        @Override
        public long getCount() {
            return this.count;
        }

        @Override
        public long getTotalSize() {
            return this.totalSize;
        }

        public String toString() {
            return "EventTypeStats [eventTypeName=" + this.eventTypeName + ", count=" + this.count + ", totalSize=" + this.totalSize + "]";
        }
    }

    static class ConstantItem
    implements IItem,
    IType<IItem> {
        private final String typeName;
        private final Object constant;

        public ConstantItem(String typeName, Object constant) {
            this.typeName = typeName;
            this.constant = constant;
        }

        @Override
        public String getName() {
            return this.typeName;
        }

        @Override
        public String getDescription() {
            return null;
        }

        @Override
        public List<IAttribute<?>> getAttributes() {
            return Collections.emptyList();
        }

        @Override
        public Map<IAccessorKey<?>, ? extends IDescribable> getAccessorKeys() {
            return null;
        }

        @Override
        public boolean hasAttribute(ICanonicalAccessorFactory<?> attribute) {
            return false;
        }

        @Override
        public <M> IMemberAccessor<M, IItem> getAccessor(IAccessorKey<M> attribute) {
            if ("typeName".equals(attribute.getIdentifier())) {
                return MemberAccessorToolkit.constant(this.typeName);
            }
            if ("constant".equals(attribute.getIdentifier())) {
                IMCStackTrace stackTrace;
                if (this.constant instanceof IMCStackTrace && !(stackTrace = (IMCStackTrace)this.constant).getFrames().isEmpty()) {
                    IMCFrame imcFrame = stackTrace.getFrames().get(0);
                    String str = StacktraceFormatToolkit.formatFrame(imcFrame, new FrameSeparator(FrameSeparator.FrameCategorization.METHOD, false));
                    return MemberAccessorToolkit.constant(str);
                }
                return MemberAccessorToolkit.constant(this.constant);
            }
            if ("stackTrace".equals(attribute.getIdentifier()) && this.constant instanceof IMCStackTrace) {
                return MemberAccessorToolkit.constant((IMCStackTrace)this.constant);
            }
            return null;
        }

        @Override
        public String getIdentifier() {
            return "constantValueType";
        }

        @Override
        public IType<?> getType() {
            return this;
        }
    }

    static class ConstPoolItem
    implements IItem,
    IType<IItem> {
        private final String name;
        private long count;
        private final long size;

        @Override
        public IType<?> getType() {
            return this;
        }

        public ConstPoolItem(String name, long count, long size) {
            this.name = name;
            this.count = count;
            this.size = size;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getDescription() {
            return "ConstantPoolStats";
        }

        @Override
        public List<IAttribute<?>> getAttributes() {
            return Collections.emptyList();
        }

        @Override
        public Map<IAccessorKey<?>, ? extends IDescribable> getAccessorKeys() {
            return null;
        }

        @Override
        public boolean hasAttribute(ICanonicalAccessorFactory<?> attribute) {
            return false;
        }

        @Override
        public <M> IMemberAccessor<M, IItem> getAccessor(IAccessorKey<M> attribute) {
            if ("name".equals(attribute.getIdentifier())) {
                return MemberAccessorToolkit.constant(this.name);
            }
            if ("count".equals(attribute.getIdentifier())) {
                return MemberAccessorToolkit.constant(this.count);
            }
            if ("size".equals(attribute.getIdentifier())) {
                return MemberAccessorToolkit.constant(UnitLookup.BYTE.quantity(this.size));
            }
            return null;
        }

        @Override
        public String getIdentifier() {
            return "constPoolStatsType";
        }
    }
}

