/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.agent;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.security.ProtectionDomain;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.commons.SerialVersionUIDAdder;
import org.objectweb.asm.util.CheckClassAdapter;
import org.qubership.profiler.agent.DefaultMethodImplInfo;
import org.qubership.profiler.agent.EnhancementRegistry;
import org.qubership.profiler.agent.StaticInitMerger;
import org.qubership.profiler.agent.StringUtils;
import org.qubership.profiler.agent.plugins.ConfigurationSPI;
import org.qubership.profiler.configuration.Rule;
import org.qubership.profiler.instrument.EnhancingClassVisitor;
import org.qubership.profiler.instrument.GatherRulesForMethodVisitor;
import org.qubership.profiler.instrument.ProfileClassAdapter;
import org.qubership.profiler.instrument.TypeUtils;
import org.qubership.profiler.instrument.custom.util.DefaultMethodAdder;
import org.qubership.profiler.instrument.enhancement.ClassInfo;
import org.qubership.profiler.instrument.enhancement.ClassInfoImpl;
import org.qubership.profiler.instrument.enhancement.EnhancerPlugin;
import org.qubership.profiler.util.MethodInstrumentationInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProfilingTransformer
implements ClassFileTransformer {
    private static final Logger log = LoggerFactory.getLogger(ProfilingTransformer.class);
    private volatile ConfigurationSPI conf;

    public ProfilingTransformer(ConfigurationSPI conf) {
        this.conf = conf;
    }

    public ConfigurationSPI getConfiguration() {
        return this.conf;
    }

    public void setConfiguration(ConfigurationSPI conf) {
        this.conf = conf;
    }

    public boolean transformRequired(String className) {
        Collection<Rule> rules = this.conf.getRulesForClass(className, null);
        EnhancementRegistry enhancementRegistry = this.conf.getEnhancementRegistry();
        List enhancers = enhancementRegistry.getEnhancers(className);
        return !rules.isEmpty() || !enhancers.isEmpty();
    }

    @Override
    public byte[] transform(ClassLoader loader, String name, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
        try {
            ClassWriter cw;
            log.trace("Transformer called for class {}", (Object)name);
            Collection<Rule> rules = this.conf.getRulesForClass(name, null);
            EnhancementRegistry enhancementRegistry = this.conf.getEnhancementRegistry();
            List enhancers = enhancementRegistry.getEnhancers(name);
            List<DefaultMethodImplInfo> defaultMethods = this.conf.getDefaultMethods(name);
            if (rules.isEmpty() && enhancers.isEmpty() && defaultMethods.isEmpty()) {
                return null;
            }
            ClassInfoImpl classInfo = new ClassInfoImpl();
            classInfo.setClassName(name);
            classInfo.setProtectionDomain(protectionDomain);
            Iterator<Rule> it = rules.iterator();
            while (it.hasNext()) {
                Rule rule = it.next();
                String ifEnhancer = rule.getIfEnhancer();
                if (ifEnhancer == null) continue;
                EnhancerPlugin filter = (EnhancerPlugin)enhancementRegistry.getFilter(ifEnhancer);
                if (filter == null) {
                    log.warn("Filter {} is not found. Please check if-enhancer attributes", (Object)ifEnhancer);
                    continue;
                }
                if (filter.accept(classInfo)) continue;
                log.trace("Skipping rule {} since filter {} does not match class {}", rule, ifEnhancer, classInfo.getClassName());
                it.remove();
            }
            ClassReader cr = new ClassReader(classfileBuffer);
            HashMap<String, MethodInstrumentationInfo> selectedRules = new HashMap<String, MethodInstrumentationInfo>();
            if (!rules.isEmpty()) {
                ClassVisitor gatherVisitor = new GatherRulesForMethodVisitor(selectedRules, rules);
                gatherVisitor = ProfilingTransformer.addDefaultMethods(gatherVisitor, defaultMethods, enhancementRegistry, classInfo);
                cr.accept(gatherVisitor, 4);
            }
            ClassVisitor cv = cw = new ClassWriter(cr, 1);
            if (!enhancers.isEmpty()) {
                cv = new StaticInitMerger("clinit$merger$profiler", cv);
                log.debug("Class {} will be updated by {} enhancers", (Object)name, (Object)enhancers.size());
                cv = new EnhancingClassVisitor(cv, enhancers, classInfo);
            }
            if (selectedRules.isEmpty()) {
                log.debug("No profiling rules match class {}", (Object)name);
            } else {
                cv = new ProfileClassAdapter(cv, name, selectedRules, TypeUtils.getJarName(protectionDomain));
            }
            cv = ProfilingTransformer.addDefaultMethods(cv, defaultMethods, enhancementRegistry, classInfo);
            if (!enhancers.isEmpty()) {
                log.debug("Adding serialVersionUID to class {}", (Object)name);
                cv = new SerialVersionUIDAdder(cv);
            }
            cr.accept(cv, 8);
            byte[] bytes = cw.toByteArray();
            String path = this.conf.getStoreTransformedClassesPath();
            if (path != null) {
                this.storeTransformationResult(name, bytes, path);
                this.storeTransformationResult(name + "$$ESC$$ORIGINAL", classfileBuffer, path);
            }
            if (this.conf.isVerifyClassEnabled()) {
                CheckClassAdapter checker = new CheckClassAdapter(new ClassVisitor(589824){

                    @Override
                    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                        return new MethodVisitor(589824){};
                    }
                });
                ClassReader reader = new ClassReader(bytes);
                reader.accept(checker, 0);
            }
            return bytes;
        }
        catch (RuntimeException e) {
            log.warn("Unable to instrument class {}, {}", (Object)name, (Object)StringUtils.throwableToString(e));
            throw e;
        }
    }

    private static ClassVisitor addDefaultMethods(ClassVisitor cv, List<DefaultMethodImplInfo> defaultMethods, EnhancementRegistry enhancementRegistry, ClassInfo classInfo) {
        if (defaultMethods.isEmpty()) {
            return cv;
        }
        for (DefaultMethodImplInfo defaultMethod : defaultMethods) {
            String ifEnhancer = defaultMethod.ifEnhancer;
            if (ifEnhancer != null) {
                EnhancerPlugin filter = (EnhancerPlugin)enhancementRegistry.getFilter(ifEnhancer);
                if (filter == null) {
                    log.warn("Filter {} is not found. Please check if-enhancer attributes", (Object)ifEnhancer);
                } else if (!filter.accept(classInfo)) {
                    log.debug("Skipped adding method {}{} to class {} since filter {} does not match", defaultMethod.methodName, defaultMethod.methodDescr, classInfo.getClassName(), ifEnhancer);
                    continue;
                }
            }
            cv = new DefaultMethodAdder(cv, defaultMethod);
        }
        return cv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeTransformationResult(String name, byte[] bytes, String path) {
        File out = new File(path, name + ".class");
        log.trace("Storing class {} to {}", (Object)name, (Object)out);
        File parentFile = out.getParentFile();
        if (!parentFile.exists() && !parentFile.mkdirs()) {
            log.warn("Unable to create folders for class {}", (Object)name);
        }
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(out);
            fos.write(bytes);
        }
        catch (FileNotFoundException e) {
            log.error("Unable to save class {}", (Object)name, (Object)e);
        }
        catch (IOException e) {
            log.error("Unable to save class {}", (Object)name, (Object)e);
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {}
            }
        }
    }
}

