/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.agent;

import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.qubership.profiler.agent.StaticInitReturnPatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StaticInitMerger
extends ClassVisitor {
    private static final Logger log = LoggerFactory.getLogger(StaticInitMerger.class);
    private String className;
    private MethodVisitor mergedClinit;
    private final String prefix;
    private int counter;
    private boolean isInterface;

    public StaticInitMerger(String prefix, ClassVisitor cv) {
        this(589824, prefix, cv);
    }

    protected StaticInitMerger(int api, String prefix, ClassVisitor cv) {
        super(api, cv);
        this.prefix = prefix;
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.cv.visit(version, access, name, signature, superName, interfaces);
        this.className = name;
        this.isInterface = (access & 0x200) > 0;
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor mv;
        if (!"<clinit>".equals(name)) {
            mv = this.cv.visitMethod(access, name, desc, signature, exceptions);
        } else {
            int a = 10;
            if (this.mergedClinit == null) {
                log.trace("Adding method {} to class {} that will merge all <clinit>s (if more than one)", (Object)this.prefix, (Object)this.className);
                this.mergedClinit = this.cv.visitMethod(a, this.prefix, "()V", null, null);
                mv = this.cv.visitMethod(access, name, desc, signature, exceptions);
                mv = new StaticInitReturnPatcher(mv, this.className, this.prefix, "()V", this.isInterface);
            } else {
                String n = this.prefix + this.counter++;
                mv = this.cv.visitMethod(a, n, desc, signature, exceptions);
                log.info("Adding method {} to class {} with code of {}", n, this.className, name);
                this.mergedClinit.visitMethodInsn(184, this.className, n, desc, false);
            }
        }
        return mv;
    }

    @Override
    public void visitEnd() {
        if (this.mergedClinit != null) {
            log.trace("Closing {} method", (Object)this.prefix);
            this.mergedClinit.visitInsn(177);
            this.mergedClinit.visitMaxs(0, 0);
            this.mergedClinit.visitEnd();
        }
        super.visitEnd();
    }
}

