/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.agent.http;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.qubership.profiler.agent.http.CookieAdapter;
import org.qubership.profiler.agent.http.HttpSessionAdapter;

public class HttpServletRequestAdapter {
    private Object httpServletRequest;
    private Method getSession;
    private Method getRequestURL;
    private Method getQueryString;
    private Method getRequestedSessionId;
    private Method getMethod;
    private Method getHeader;
    private Method getCookies;
    private Method setAttribute;

    public HttpServletRequestAdapter(Object httpServletRequest) throws NoSuchMethodException {
        this.httpServletRequest = httpServletRequest;
        this.getSession = this.httpServletRequest.getClass().getMethod("getSession", Boolean.TYPE);
        this.getRequestURL = this.httpServletRequest.getClass().getMethod("getRequestURL", new Class[0]);
        this.getQueryString = this.httpServletRequest.getClass().getMethod("getQueryString", new Class[0]);
        this.getRequestedSessionId = this.httpServletRequest.getClass().getMethod("getRequestedSessionId", new Class[0]);
        this.getMethod = this.httpServletRequest.getClass().getMethod("getMethod", new Class[0]);
        this.getHeader = this.httpServletRequest.getClass().getMethod("getHeader", String.class);
        this.getCookies = this.httpServletRequest.getClass().getMethod("getCookies", new Class[0]);
        this.setAttribute = this.httpServletRequest.getClass().getMethod("setAttribute", String.class, Object.class);
    }

    public HttpSessionAdapter getSession(boolean createSession) throws InvocationTargetException, IllegalAccessException, NoSuchMethodException {
        Object session = this.getSession.invoke(this.httpServletRequest, createSession);
        if (session == null) {
            return null;
        }
        return new HttpSessionAdapter(session);
    }

    public StringBuffer getRequestURL() throws InvocationTargetException, IllegalAccessException {
        return (StringBuffer)this.getRequestURL.invoke(this.httpServletRequest, new Object[0]);
    }

    public String getQueryString() throws InvocationTargetException, IllegalAccessException {
        return (String)this.getQueryString.invoke(this.httpServletRequest, new Object[0]);
    }

    public String getRequestedSessionId() throws InvocationTargetException, IllegalAccessException {
        return (String)this.getRequestedSessionId.invoke(this.httpServletRequest, new Object[0]);
    }

    public String getMethod() throws InvocationTargetException, IllegalAccessException {
        return (String)this.getMethod.invoke(this.httpServletRequest, new Object[0]);
    }

    public String getHeader(String name) throws InvocationTargetException, IllegalAccessException {
        return (String)this.getHeader.invoke(this.httpServletRequest, name);
    }

    public CookieAdapter[] getCookies() throws InvocationTargetException, IllegalAccessException, NoSuchMethodException {
        Object[] cookies = (Object[])this.getCookies.invoke(this.httpServletRequest, new Object[0]);
        if (cookies == null) {
            return null;
        }
        CookieAdapter[] result = new CookieAdapter[cookies.length];
        for (int i = 0; i < cookies.length; ++i) {
            result[i] = new CookieAdapter(cookies[i]);
        }
        return result;
    }

    public void setAttribute(String name, Object value) throws InvocationTargetException, IllegalAccessException {
        this.setAttribute.invoke(this.httpServletRequest, name, value);
    }
}

