/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.agent.plugins;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Semaphore;
import org.qubership.profiler.Dumper;
import org.qubership.profiler.agent.Bootstrap;
import org.qubership.profiler.agent.Configuration_05;
import org.qubership.profiler.agent.DumperCollectorClientFactory;
import org.qubership.profiler.agent.DumperPlugin;
import org.qubership.profiler.agent.DumperPlugin_10;
import org.qubership.profiler.agent.LocalBuffer;
import org.qubership.profiler.agent.LocalState;
import org.qubership.profiler.agent.NetworkExportParams;
import org.qubership.profiler.agent.Profiler;
import org.qubership.profiler.agent.ProfilerData;
import org.qubership.profiler.agent.ProfilerTransformerPlugin;
import org.qubership.profiler.agent.ThreadJMXProviderFactory;
import org.qubership.profiler.client.CollectorClientFactory;
import org.qubership.profiler.dump.DumpRootResolver;
import org.qubership.profiler.dump.DumperThread;
import org.qubership.profiler.dump.ThreadState;
import org.qubership.profiler.metrics.MetricsPluginImpl;
import org.qubership.profiler.transfer.DataSender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DumperPluginImpl
implements DumperPlugin_10 {
    private static final Logger log = LoggerFactory.getLogger(DumperPluginImpl.class);
    Dumper dumper;
    DumperThread dumperThread;
    DataSender dataSender;
    private BlockingQueue<LocalBuffer> dirtyBuffers;
    private BlockingQueue<LocalBuffer> emptyBuffers;
    private ConcurrentMap<Thread, LocalState> activeThreads;
    private MetricsPluginImpl metricsPlugin;
    private final Semaphore startingSemaphore = new Semaphore(1);

    public DumperPluginImpl() {
        Bootstrap.registerPlugin(DumperPlugin.class, this);
        this.metricsPlugin = new MetricsPluginImpl();
    }

    @Override
    public void newDumper(BlockingQueue<LocalBuffer> dirtyBuffers, BlockingQueue<LocalBuffer> emptyBuffers, ArrayList<LocalBuffer> buffers) {
        throw new UnsupportedOperationException("Unsupported operation");
    }

    @Override
    public void newDumper(BlockingQueue<LocalBuffer> dirtyBuffers, BlockingQueue<LocalBuffer> emptyBuffers, ConcurrentMap<Thread, LocalState> activeThreads) {
        this.dirtyBuffers = dirtyBuffers;
        this.emptyBuffers = emptyBuffers;
        this.activeThreads = activeThreads;
        this.start();
    }

    @Override
    public void reconfigure() {
        ProfilerTransformerPlugin transformer = Bootstrap.getPlugin(ProfilerTransformerPlugin.class);
        Configuration_05 conf = (Configuration_05)transformer.getConfiguration();
        conf.getParameterInfo("profiler.title").index(true);
        this.dumper.configure(conf.getParametersInfo(), conf.getLogMaxAge(), conf.getLogMaxSize(), conf.getMetricsConfig(), conf.getSystemMetricsConfig());
        this.reconfigureCallsExporter(conf.getNetworkExportParams());
    }

    private void reconfigureCallsExporter(NetworkExportParams exportParams) {
        if (ProfilerData.DISABLE_CALL_EXPORT) {
            return;
        }
        if (exportParams != null) {
            if (this.dataSender == null) {
                this.dataSender = new DataSender(exportParams);
                this.dataSender.start();
            } else {
                this.dataSender.configure(exportParams);
            }
            this.dumper.getDumperCallsExporter().configureExport(this.dataSender.getJsonsToSend(), this.dataSender.getEmptyJsonBuffers(), exportParams);
        } else if (this.dataSender != null) {
            this.dumper.getDumperCallsExporter().configureExport(null, null, null);
            this.dataSender.shutdown();
            this.dataSender = null;
        }
    }

    @Override
    public File getCurrentRoot() {
        Dumper dumper = this.dumper;
        if (dumper == null) {
            return null;
        }
        return dumper.getCurrentRoot();
    }

    @Override
    public List<String> getTags() {
        return ProfilerData.getTags();
    }

    @Override
    public boolean start() {
        if (!this.startingSemaphore.tryAcquire()) {
            throw new IllegalStateException("Start/shutdown is in progress. Please, try later");
        }
        try {
            if (this.dumper != null || this.dumperThread != null) {
                throw new IllegalStateException("Cannot start dumper as there is another running one");
            }
            String dumpFolder = DumpRootResolver.dumpRoot;
            log.info("Using the following dump folder: {}", (Object)dumpFolder);
            this.dumper = new Dumper(this.dirtyBuffers, this.emptyBuffers, this.activeThreads, dumpFolder, this.metricsPlugin);
            this.reconfigure();
            this.dumperThread = new DumperThread(this.dumper, "Profiler results dumper " + dumpFolder);
            boolean bl = false;
            return bl;
        }
        finally {
            this.startingSemaphore.release();
        }
    }

    @Override
    public boolean stop(boolean force) {
        if (!this.startingSemaphore.tryAcquire()) {
            throw new IllegalStateException("Start/shutdown is in progress. Please, try later");
        }
        try {
            if (this.dumperThread == null) {
                boolean bl = false;
                return bl;
            }
            this.dumperThread.shutdown();
            if (force) {
                this.dumperThread.interrupt();
            }
            this.dumperThread.join(5000L);
            this.dumperThread = null;
            this.dumper = null;
            boolean bl = true;
            return bl;
        }
        finally {
            this.startingSemaphore.release();
        }
    }

    @Override
    public boolean isStarted() {
        return this.dumperThread != null && this.dumperThread.isAlive() && !ProfilerData.dumperDead;
    }

    @Override
    public int getNumberOfRestarts() {
        return ProfilerData.dumperIncarnation;
    }

    @Override
    public long getWrittenRecords() {
        Dumper dumper = this.dumper;
        if (dumper == null) {
            return 0L;
        }
        return dumper.getRecordsWritten();
    }

    @Override
    public long getWrittenBytes() {
        Dumper dumper = this.dumper;
        if (dumper == null) {
            return 0L;
        }
        return dumper.getCompressedSize();
    }

    @Override
    public long getUncompressedSize() {
        Dumper dumper = this.dumper;
        if (dumper == null) {
            return 0L;
        }
        return dumper.getUncompressedSize();
    }

    @Override
    public long getWriteTime() {
        Dumper dumper = this.dumper;
        if (dumper == null) {
            return 0L;
        }
        return dumper.getDumpTime();
    }

    @Override
    public long getDumperStartTime() {
        Dumper dumper = this.dumper;
        if (dumper == null) {
            return 0L;
        }
        return dumper.getDumperStartTime();
    }

    @Override
    public Object[] getInflightCalls() {
        if (!this.isStarted()) {
            return null;
        }
        Object[] result = new Object[2];
        this.callDumper((byte)4, result, 20000L);
        return result[0] != null ? result : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean callDumper(byte commandId, Object[] arg, long timeout) {
        LocalBuffer buffer = ProfilerData.getEmptyBuffer(Profiler.getState());
        int restarts = this.getNumberOfRestarts();
        buffer.command(commandId, arg);
        ProfilerData.addDirtyBuffer(buffer, true);
        long deadline = System.currentTimeMillis() + timeout;
        Object[] objectArray = arg;
        synchronized (arg) {
            while (System.currentTimeMillis() < deadline && arg[0] == null && restarts == this.getNumberOfRestarts()) {
                try {
                    arg.wait(Math.max(deadline - System.currentTimeMillis(), 100L));
                }
                catch (InterruptedException interruptedException) {}
            }
            // ** MonitorExit[var9_7] (shouldn't be in output)
            return arg[0] != null;
        }
    }

    @Override
    public long getBytesAllocated() {
        Dumper dumper = this.dumper;
        if (dumper == null) {
            return 0L;
        }
        LocalState state = dumper.localState;
        if (state == null) {
            return 0L;
        }
        ThreadJMXProviderFactory.INSTANCE.updateThreadCounters(state);
        ThreadState prevState = (ThreadState)state.additional;
        if (prevState == null) {
            return state.memoryUsed;
        }
        return state.memoryUsed - prevState.prevMemoryUsed;
    }

    @Override
    public long getCPUTime() {
        Dumper dumper = this.dumper;
        if (dumper == null) {
            return 0L;
        }
        LocalState state = dumper.localState;
        if (state == null) {
            return 0L;
        }
        ThreadJMXProviderFactory.INSTANCE.updateThreadCounters(state);
        ThreadState prevState = (ThreadState)state.additional;
        if (prevState == null) {
            return state.cpuTime;
        }
        return state.cpuTime - prevState.prevCpuTime;
    }

    @Override
    public long getFileRead() {
        Dumper dumper = this.dumper;
        if (dumper == null) {
            return 0L;
        }
        LocalState state = dumper.localState;
        if (state == null) {
            return 0L;
        }
        ThreadState prevState = (ThreadState)state.additional;
        if (prevState == null) {
            return state.fileRead;
        }
        return state.fileRead - prevState.prevFileRead;
    }

    @Override
    public long getFileWritten() {
        Dumper dumper = this.dumper;
        if (dumper == null) {
            return 0L;
        }
        LocalState state = dumper.localState;
        if (state == null) {
            return 0L;
        }
        ThreadState prevState = (ThreadState)state.additional;
        if (prevState == null) {
            return state.fileWritten;
        }
        return state.fileWritten - prevState.prevFileWritten;
    }

    @Override
    public boolean gracefulShutdown() {
        return this.gracefulShutdown(5000L);
    }

    @Override
    public boolean gracefulShutdown(long timeout) {
        if (!this.isStarted()) {
            return true;
        }
        Object[] result = new Object[1];
        return this.callDumper((byte)5, result, timeout);
    }

    @Override
    public long getArchiveSize() {
        Dumper dumper = this.dumper;
        if (dumper == null) {
            return 0L;
        }
        return dumper.getArchiveSize();
    }

    @Override
    public void forceRescanDumpDir() {
        Dumper dumper = this.dumper;
        if (dumper == null) {
            return;
        }
        dumper.forceRescanDumpDir();
    }

    @Override
    public String getMetrics() {
        return this.metricsPlugin.getMetrics();
    }

    @Override
    public void injectCollectorClientFactory(DumperCollectorClientFactory toInject) {
        CollectorClientFactory.injectFactory(toInject);
    }

    @Override
    public DumperCollectorClientFactory getCollectorClientFactory() {
        return CollectorClientFactory.instance();
    }

    @Override
    public boolean isInitialized() {
        return this.dumper != null && this.dumper.isInitialized();
    }
}

