/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.agent.plugins;

import ch.qos.logback.classic.BasicConfigurator;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.core.joran.spi.JoranException;
import java.io.File;
import java.io.IOException;
import java.lang.instrument.Instrumentation;
import java.util.Set;
import java.util.concurrent.Semaphore;
import java.util.logging.Level;
import javax.xml.parsers.ParserConfigurationException;
import org.qubership.profiler.agent.Bootstrap;
import org.qubership.profiler.agent.Configuration;
import org.qubership.profiler.agent.ConfigurationReloader;
import org.qubership.profiler.agent.DumperPlugin;
import org.qubership.profiler.agent.DumperPlugin_01;
import org.qubership.profiler.agent.ESCLogger;
import org.qubership.profiler.agent.LocalState;
import org.qubership.profiler.agent.ProfilerData;
import org.qubership.profiler.agent.ProfilerTransformerPlugin;
import org.qubership.profiler.agent.ProfilerTransformerPlugin_01;
import org.qubership.profiler.agent.ProfilingTransformer;
import org.qubership.profiler.agent.ReloadStatus;
import org.qubership.profiler.agent.ReloadStatusImpl;
import org.qubership.profiler.agent.ReloadStatusMutable;
import org.qubership.profiler.agent.TwoPhaseInit;
import org.qubership.profiler.agent.plugins.ConfigurationSPI;
import org.qubership.profiler.agent.plugins.ProfilerPluginLoggerImpl;
import org.qubership.profiler.configuration.ConfigurationImpl;
import org.qubership.profiler.configuration.PropertyFacade;
import org.qubership.profiler.dump.DumpRootResolver;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class ProfilerTransformerPluginImpl
implements ProfilerTransformerPlugin_01,
TwoPhaseInit {
    private static final ESCLogger logger = ESCLogger.getLogger(ProfilerTransformerPluginImpl.class.getName());
    final ProfilingTransformer profiler;
    final ReloadStatusMutable reloadStatus = new ReloadStatusImpl();
    private final Semaphore reloadingSemaphore = new Semaphore(1);

    public ProfilerTransformerPluginImpl() {
        this.configureLogback();
        this.profiler = new ProfilingTransformer(null);
        Bootstrap.registerPlugin(ProfilerTransformerPlugin.class, this);
        new LocalState();
    }

    @Override
    public void start() throws IOException, SAXException, ParserConfigurationException {
        String configPath = DumpRootResolver.CONFIG_FILE;
        ConfigurationImpl conf = new ConfigurationImpl(configPath);
        this.profiler.setConfiguration(conf);
        ProfilerData.properties = conf.getProperties();
        this.reloadStatus.setConfigPath(conf.getConfigFile());
        this.reloadStatus.setMessage("Initial configuration");
        Bootstrap.getInstrumentation().addTransformer(this.profiler, true);
    }

    private void configureLogback() {
        File file;
        LoggerContext lc = (LoggerContext)LoggerFactory.getILoggerFactory();
        String logbackXmlPath = PropertyFacade.getProperty("profiler.log.config", null);
        if (logbackXmlPath == null && (file = new File(new File(DumpRootResolver.PROFILER_HOME), "config/logback.xml")).exists()) {
            logbackXmlPath = file.getAbsolutePath();
        }
        if (logbackXmlPath == null) {
            logger.warning("Profiler: unable to find logback.xml configuration file, please place it near _config.xml or specify its location via profiler.log.config property");
        }
        try {
            JoranConfigurator configurator = new JoranConfigurator();
            configurator.setContext(lc);
            lc.reset();
            if (logbackXmlPath != null) {
                logger.fine("Profiler: reading logback configuration from " + logbackXmlPath);
                configurator.doConfigure(logbackXmlPath);
            } else {
                logger.fine("Profiler: trying to find logback.xml in classpath");
                configurator.doConfigure(this.getClass().getResourceAsStream("logback.xml"));
            }
        }
        catch (JoranException je) {
            logger.log(Level.SEVERE, "Unable to load logging configuration from " + logbackXmlPath, je);
            new BasicConfigurator().configure(lc);
        }
        ProfilerData.pluginLogger = new ProfilerPluginLoggerImpl();
    }

    @Override
    public Configuration getConfiguration() {
        return this.profiler.getConfiguration();
    }

    @Override
    public ReloadStatus getReloadStatus() {
        return this.reloadStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reloadConfiguration(String newConfigPath) throws IOException, SAXException, ParserConfigurationException {
        if (!this.reloadingSemaphore.tryAcquire()) {
            throw new IllegalStateException("Reload is in progress. Please, try later");
        }
        boolean threadStarted = false;
        try {
            this.reloadStatus.setMessage("Initializing");
            this.reloadStatus.setDone(false);
            this.reloadStatus.setTotalCount(1);
            this.reloadStatus.setSuccessCount(0);
            this.reloadStatus.setErrorCount(0);
            ConfigurationSPI conf = this.profiler.getConfiguration();
            this.reloadStatus.setConfigPath(conf.getConfigFile());
            if (newConfigPath == null || newConfigPath.length() == 0) {
                logger.warning("New configuration path was not set, reusing the path of active configuration");
                newConfigPath = conf.getConfigFile();
            }
            logger.info("Reloading configuration from " + newConfigPath);
            this.reloadStatus.setMessage("Loading configuration from " + newConfigPath);
            ConfigurationImpl newConf = new ConfigurationImpl(newConfigPath);
            if (((Object)newConf).equals(conf)) {
                this.reloadStatus.setMessage("New configuration is identical to the previously loaded one");
                this.reloadStatus.setDone(true);
                this.reloadStatus.setSuccessCount(1);
                return;
            }
            this.reloadStatus.setConfigPath(newConf.getConfigFile());
            ProfilerData.properties = conf.getProperties();
            this.profiler.setConfiguration(newConf);
            DumperPlugin dumper = Bootstrap.getPlugin(DumperPlugin.class);
            try {
                if (dumper instanceof DumperPlugin_01) {
                    DumperPlugin_01 dumper01 = (DumperPlugin_01)dumper;
                    dumper01.reconfigure();
                }
            }
            catch (Throwable t) {
                logger.log(Level.WARNING, "Unable to reconfigure dumper", t);
            }
            Instrumentation inst = Bootstrap.getInstrumentation();
            if (!inst.isRedefineClassesSupported()) {
                this.reloadStatus.setMessage("JVM does not support class redefinition. Only newly loaded classes would use new configuration");
                this.reloadStatus.setDone(true);
                this.reloadStatus.setErrorCount(1);
                return;
            }
            new Thread(new ConfigurationReloader(conf, newConf, null, inst, this.reloadStatus, this.reloadingSemaphore)).start();
            threadStarted = true;
        }
        finally {
            if (!threadStarted) {
                this.reloadStatus.setDone(true);
                this.reloadingSemaphore.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reloadClasses(Set<String> classNames) throws IOException, SAXException, ParserConfigurationException {
        if (!this.reloadingSemaphore.tryAcquire()) {
            throw new IllegalStateException("Reload is in progress. Please, try later");
        }
        boolean threadStarted = false;
        try {
            this.reloadStatus.setMessage("Initializing");
            this.reloadStatus.setDone(false);
            this.reloadStatus.setTotalCount(1);
            this.reloadStatus.setSuccessCount(0);
            this.reloadStatus.setErrorCount(0);
            Instrumentation inst = Bootstrap.getInstrumentation();
            if (!inst.isRedefineClassesSupported()) {
                this.reloadStatus.setMessage("JVM does not support class redefinition. Only newly loaded classes would use new configuration");
                this.reloadStatus.setDone(true);
                this.reloadStatus.setErrorCount(1);
                return;
            }
            new ConfigurationReloader(null, this.profiler.getConfiguration(), classNames, inst, this.reloadStatus, this.reloadingSemaphore).run();
            threadStarted = true;
        }
        finally {
            if (!threadStarted) {
                this.reloadStatus.setDone(true);
                this.reloadingSemaphore.release();
            }
        }
    }
}

