/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.client;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.ConnectException;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.apache.commons.lang.StringUtils;
import org.apache.http.ssl.SSLContextBuilder;
import org.qubership.profiler.agent.DumperCollectorClient;
import org.qubership.profiler.agent.DumperRemoteControlledStream;
import org.qubership.profiler.client.CollectorClientFactory;
import org.qubership.profiler.cloud.transport.EndlessSocketInputStream;
import org.qubership.profiler.cloud.transport.FieldIO;
import org.qubership.profiler.cloud.transport.ProfilerProtocolBlacklistedException;
import org.qubership.profiler.cloud.transport.ProfilerProtocolException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCollectorClient
implements DumperCollectorClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultCollectorClient.class);
    public static final long BLOCKING_WRITE_TIMEOUT = 10L;
    public static final String ENV_NC_DIAGNOSTIC_FOLDER = "NC_DIAGNOSTIC_FOLDER";
    public static final String ENV_KEYSTORE_FILE_PATH = "NC_DIAGNOSTIC_KEYSTORE";
    public static final String ENV_KEYSTORE_PASSWORD = "NC_DIAGNOSTIC_KEYSTORE_PASSWD";
    public static final String TLS_KEYSTORE_PATH = "TLS_KEYSTORE_PATH";
    public static final String TLS_KEYSTORE_PASSWORD = "TLS_KEYSTORE_PWD";
    public static final int NUM_RETRY_ATTEMPTS = 2;
    public static final int PAUSE_BETWEEN_RETRIES_MILLIS = 1000;
    private final String cloudNamespace;
    private final String microserviceName;
    private final String podName;
    private final String host;
    private final int port;
    private final boolean ssl;
    private Socket socket;
    private boolean needsReconnect = true;
    private FieldIO fieldIO;
    private OutputStream out;
    private BufferedInputStream in;
    private InputStream sin;
    private long version;
    private int pendingAcks = 0;
    private final Map<UUID, Process> runningCommands = new HashMap<UUID, Process>();
    private final Map<String, UUID> streamHandles = new HashMap<String, UUID>();

    public DefaultCollectorClient(String host, int port, boolean ssl, String cloudNamespace, String microserviceName, String podName) {
        this.host = host;
        this.port = port;
        this.ssl = ssl;
        this.cloudNamespace = StringUtils.isEmpty(cloudNamespace) ? "unknown" : cloudNamespace;
        this.microserviceName = StringUtils.isEmpty(microserviceName) ? "unknown" : microserviceName;
        this.podName = StringUtils.isEmpty(podName) ? "unknown" : podName;
        this.version = -1L;
        try {
            this.getFieldIO();
        }
        catch (IOException e) {
            throw new ProfilerProtocolException(e);
        }
        this.reportPodName();
    }

    protected void reportPodName() {
        try {
            String diagnosticFolder = System.getenv(ENV_NC_DIAGNOSTIC_FOLDER);
            if (StringUtils.isBlank(diagnosticFolder)) {
                return;
            }
            File podNameFile = new File(new File(diagnosticFolder), "pod.name");
            try (OutputStreamWriter fout = new OutputStreamWriter(new BufferedOutputStream(new FileOutputStream(podNameFile)));){
                fout.write(this.podName);
            }
        }
        catch (IOException e) {
            log.info("Can not create file with pod name {}", (Object)this.podName);
        }
    }

    private FieldIO getFieldIO() throws IOException {
        if (this.socket != null && (this.socket.isClosed() || !this.socket.isConnected() || this.needsReconnect)) {
            try {
                Socket prev = this.socket;
                this.socket = null;
                this.fieldIO = null;
                prev.close();
            }
            catch (IOException e) {
                log.error("Failed to close previously unavailable socket", e);
            }
        }
        if (this.socket == null) {
            this.socket = this.openSocket(this.host, this.port, this.ssl);
            this.out = new BufferedOutputStream(this.socket.getOutputStream(), 1024);
            this.out.flush();
            this.sin = this.socket.getInputStream();
            this.in = new BufferedInputStream(new EndlessSocketInputStream(this.sin), 1024);
            this.fieldIO = new FieldIO(this.socket, this.in, this.out);
            this.out.write(20);
            this.fieldIO.writeLong(100705L);
            this.fieldIO.writeString(this.podName);
            this.fieldIO.writeString(this.microserviceName);
            this.fieldIO.writeString(this.cloudNamespace);
            this.out.flush();
            long version = this.fieldIO.readLong();
            if (version == 100605L || version == 100705L) {
                log.debug("Plain socket client connected. Using protocol version {}. ssl: {}", (Object)version, (Object)this.ssl);
                this.needsReconnect = false;
                this.pendingAcks = 0;
                this.runningCommands.clear();
                this.streamHandles.clear();
                this.version = version;
            } else {
                if (version == 88888888L) {
                    log.debug("Blacklisted Namespace: {}.", (Object)this.cloudNamespace);
                    this.needsReconnect = false;
                    this.pendingAcks = 0;
                    this.runningCommands.clear();
                    this.streamHandles.clear();
                    throw new ProfilerProtocolBlacklistedException("Blacklisted Namespace:  " + this.cloudNamespace);
                }
                try {
                    this.socket.close();
                    this.socket = null;
                }
                catch (Exception e) {
                    log.error("Failed to close socket", e);
                }
                throw new ProfilerProtocolException("Protocol version mismatch. Client version is 100505 server version is " + version);
            }
        }
        return this.fieldIO;
    }

    private SSLContext getSSLContext() throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException, UnrecoverableKeyException, KeyManagementException {
        SSLContext sslContext = null;
        String keystoreFilePath = System.getenv(ENV_KEYSTORE_FILE_PATH);
        String keystorePassword = System.getenv(ENV_KEYSTORE_PASSWORD);
        if (StringUtils.isBlank(keystoreFilePath)) {
            keystoreFilePath = System.getenv(TLS_KEYSTORE_PATH);
        }
        if (StringUtils.isBlank(keystorePassword)) {
            keystorePassword = System.getenv(TLS_KEYSTORE_PASSWORD);
        }
        KeyStore keyStore = KeyStore.getInstance("PKCS12");
        try (FileInputStream keyStoreStream = new FileInputStream(keystoreFilePath);){
            keyStore.load(keyStoreStream, keystorePassword.toCharArray());
        }
        sslContext = SSLContextBuilder.create().loadKeyMaterial(keyStore, keystorePassword.toCharArray()).loadTrustMaterial(keyStore, null).build();
        return sslContext;
    }

    private Socket initSocketOrSSL(String host, int port, boolean ssl) throws IOException, KeyManagementException, NoSuchAlgorithmException, CertificateException, KeyStoreException, UnrecoverableKeyException {
        if (ssl) {
            SSLContext sslContext = this.getSSLContext();
            SSLSocketFactory fac = sslContext.getSocketFactory();
            SSLSocket sslSocket = (SSLSocket)fac.createSocket(host, port);
            return sslSocket;
        }
        return new Socket(host, port);
    }

    private Socket openSocket(String host, int port, boolean ssl) throws IOException {
        Socket result;
        try {
            log.debug("Connecting to {}:{}. SSL: {}", host, port, ssl);
            result = this.initSocketOrSSL(host, port, ssl);
        }
        catch (ConnectException e) {
            String newHost = StringUtils.replace(host, "esc-static-service", "esc-collector-service");
            if (newHost.equals(host)) {
                throw new ProfilerProtocolException("Failed to connect to " + host + ":" + port);
            }
            log.warn("Failed to connect to {}:{}. Attempting a fallback to {}. SSL: {}", host, port, newHost, ssl);
            try {
                result = this.initSocketOrSSL(newHost, port, ssl);
            }
            catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException e1) {
                log.warn("Failed to connect to {}:{}, reason: {}", host, port, e1);
                throw new ProfilerProtocolException("Unable to Connect");
            }
            catch (Exception e1) {
                log.warn("Failed to connect host: reason: {}", e1);
                throw new ProfilerProtocolException("Unable to Connect");
            }
        }
        catch (Exception e) {
            log.warn("Failed to connect host: reason: {}", e);
            throw new ProfilerProtocolException("Unable to Connect");
        }
        if (result != null) {
            result.setSendBufferSize(Short.MAX_VALUE);
            result.setReceiveBufferSize(Short.MAX_VALUE);
            result.setKeepAlive(true);
            result.setSoTimeout(30000);
            result.setSendBufferSize(8192);
            result.setReceiveBufferSize(8192);
        }
        return result;
    }

    @Override
    public void close() throws IOException {
        if (this.needsReconnect) {
            log.debug("shutdown requested but collector client needs reconnect. skipping shutdown");
            return;
        }
        try {
            if (this.out != null) {
                this.out.write(4);
                this.out.flush();
            }
        }
        finally {
            this.needsReconnect = true;
            if (this.socket != null) {
                this.socket.close();
                this.socket = null;
                this.out = null;
            }
        }
    }

    @Override
    public DumperRemoteControlledStream createRollingChunk(String streamName, int requestedRollingSequenceId, boolean resetRequired) throws IOException {
        try {
            return this.attemptCreateRollingChunk(streamName, requestedRollingSequenceId, resetRequired);
        }
        catch (Exception e) {
            this.needsReconnect = true;
            throw new ProfilerProtocolException(e);
        }
    }

    private DumperRemoteControlledStream attemptCreateRollingChunk(String streamName, int requestedRollingSequenceId, boolean resetRequired) throws IOException {
        FieldIO io = this.getFieldIO();
        this.validateWriteDataAcks(true);
        io.writeCommand(21);
        io.writeString(streamName);
        io.writeInt(requestedRollingSequenceId);
        io.writeInt(resetRequired ? 1 : 0);
        this.out.flush();
        UUID streamHandle = io.readUUID();
        if (streamHandle == null) {
            throw new ProfilerProtocolException("failed to open stream " + streamName);
        }
        this.streamHandles.put(streamName, streamHandle);
        long rotationPeriod = io.readLong();
        long requiredRotationSize = io.readLong();
        int serverRollingSequenceId = io.readInt();
        return CollectorClientFactory.instance().wrapOutputStream(serverRollingSequenceId, streamName, rotationPeriod, requiredRotationSize, this);
    }

    @Override
    public void write(byte[] bytes, int offset, int length, String streamName) throws IOException {
        if (this.needsReconnect) {
            throw new ProfilerProtocolException("Client needs reconnect. can not write");
        }
        UUID handleId = this.streamHandles.get(streamName);
        if (handleId == null) {
            throw new RuntimeException("Stream " + streamName + " has not been initialized");
        }
        try {
            int curLength;
            do {
                curLength = Math.min(length, 1024);
                this.attemptWrite(bytes, offset, curLength, handleId);
                offset += curLength;
            } while ((length -= curLength) > 0);
        }
        catch (Exception e) {
            this.needsReconnect = true;
            log.error("Failed sending packet to collector", e);
            throw new ProfilerProtocolException(e);
        }
    }

    private void attemptWrite(byte[] bytes, int offset, int length, UUID handleId) throws IOException {
        this.validateWriteDataAcks(false);
        this.getFieldIO().writeCommand(2);
        this.getFieldIO().writeUUID(handleId);
        this.getFieldIO().writeField(bytes, offset, length);
        ++this.pendingAcks;
    }

    @Override
    public boolean validateWriteDataAcks(boolean sync) throws IOException {
        if (sync) {
            this.out.flush();
        }
        while (this.pendingAcks > 0 && (sync || this.in.available() > 0)) {
            this.validateAckSync();
        }
        return this.pendingAcks == 0;
    }

    private boolean dispatchCommand(UUID id, String command) {
        log.info("Executing command {}: {}", (Object)id, (Object)command);
        try {
            String execCommand = null;
            String diagnosticFolder = System.getenv(ENV_NC_DIAGNOSTIC_FOLDER);
            if (StringUtils.isBlank(diagnosticFolder)) {
                log.warn("Command {} requires presence of ENV variable NC_DIAGNOSTIC_FOLDER", (Object)command);
                return false;
            }
            if ("heap".equals(command)) {
                log.info("run heap request");
                execCommand = diagnosticFolder + "/diagtools heap";
            } else if ("td".equals(command)) {
                log.info("run td request");
                execCommand = diagnosticFolder + "/diagtools dump";
            } else if ("top".equals(command)) {
                log.info("run top request");
                execCommand = diagnosticFolder + "/diagtools dump";
            }
            if (execCommand != null) {
                this.runningCommands.put(id, Runtime.getRuntime().exec(execCommand));
                return true;
            }
        }
        catch (Throwable t) {
            log.error("Failed to execute command {}: {}", id, command, t);
        }
        return false;
    }

    private void reportCommandResult(UUID commandId, boolean success) throws IOException {
        this.out.write(19);
        this.fieldIO.writeUUID(commandId);
        this.out.write(success ? 75 : -1);
    }

    private void dispatchCommands(int numCommands) throws IOException {
        Object cmd;
        while (numCommands > 0) {
            UUID id = this.fieldIO.readUUID();
            boolean submitted = this.dispatchCommand(id, (String)(cmd = this.fieldIO.readString()));
            if (!submitted) {
                this.reportCommandResult(id, false);
            }
            --numCommands;
        }
        Iterator<Map.Entry<UUID, Process>> it = this.runningCommands.entrySet().iterator();
        while (it.hasNext()) {
            cmd = it.next();
            try {
                int exitValue = ((Process)cmd.getValue()).exitValue();
                this.reportCommandResult((UUID)cmd.getKey(), exitValue == 0);
                it.remove();
            }
            catch (IllegalThreadStateException illegalThreadStateException) {}
        }
        this.out.flush();
    }

    private void validateAckSync() throws IOException {
        try {
            int ack = this.in.read();
            if (ack < 0) {
                throw new ProfilerProtocolException("unexpected EOF from collector");
            }
            byte byteAck = (byte)ack;
            if (byteAck < 0) {
                if (byteAck == -1) {
                    throw new ProfilerProtocolException("Collector can't accept data. stream rotation is requested");
                }
                throw new ProfilerProtocolException("Received invalid ack response " + ack);
            }
            this.dispatchCommands(byteAck);
            --this.pendingAcks;
        }
        catch (SocketTimeoutException e) {
            throw new ProfilerProtocolException("timed out waiting for ack. Number of pending acks " + this.pendingAcks, e);
        }
    }

    @Override
    public void requestAckFlush(boolean doFlush) throws IOException {
        this.getFieldIO().writeCommand(17);
        ++this.pendingAcks;
        if (doFlush) {
            this.out.flush();
        }
    }

    @Override
    public boolean isOnline() {
        return !this.needsReconnect && this.out != null && this.socket != null;
    }

    @Override
    public void flush() throws IOException {
        if (this.needsReconnect) {
            throw new ProfilerProtocolException("Client needs reconnect.can not flush");
        }
        try {
            this.requestAckFlush(false);
            this.validateWriteDataAcks(true);
        }
        catch (Exception e) {
            this.needsReconnect = true;
            throw new ProfilerProtocolException(e);
        }
    }

    @Override
    public String getPodName() {
        return this.podName;
    }

    public long getVersion() {
        return this.version;
    }
}

