/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.config;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.List;
import org.qubership.profiler.io.WildcardFileFilter;
import org.qubership.profiler.util.IOHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnalyzerWhiteList {
    private static final Logger LOGGER = LoggerFactory.getLogger(AnalyzerWhiteList.class);
    private static final String CONFIG_FILE = System.getProperty("profiler.analyzer_white_list", Boolean.getBoolean("profiler_standalone_mode") ? "config/analyzer_white_list.cfg" : "applications/execution-statistics-collector/config/analyzer_white_list.cfg");
    private static FileFilter fileFilter;

    private static List<String> loadWildcardsFromConfig() throws IOException {
        File configFile = new File(CONFIG_FILE);
        if (!configFile.exists()) {
            return null;
        }
        return IOHelper.readAllLinesFromFile(configFile);
    }

    public static boolean checkAccess(File file) {
        return fileFilter.accept(file);
    }

    static {
        try {
            List<String> wildcards;
            fileFilter = Boolean.getBoolean("profiler_local_start_mode") ? new TrueToALlFileFiler() : ((wildcards = AnalyzerWhiteList.loadWildcardsFromConfig()) == null || wildcards.isEmpty() ? new FalseToALlFileFiler() : new WildcardFileFilter(wildcards));
        }
        catch (Exception e) {
            LOGGER.error("Error in AnalyzerWhiteList: ", e);
            fileFilter = new FalseToALlFileFiler();
        }
    }

    private static class TrueToALlFileFiler
    implements FileFilter {
        private TrueToALlFileFiler() {
        }

        @Override
        public boolean accept(File pathname) {
            return true;
        }
    }

    private static class FalseToALlFileFiler
    implements FileFilter {
        private FalseToALlFileFiler() {
        }

        @Override
        public boolean accept(File pathname) {
            return false;
        }
    }
}

